/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.explainplan;

import com.gigaspaces.api.ExperimentalApi;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.IntegerObjectMap;
import com.gigaspaces.internal.query.explainplan.IndexChoiceNode;
import com.gigaspaces.internal.query.explainplan.IndexInfo;
import com.gigaspaces.internal.query.explainplan.QueryOperationNode;
import com.gigaspaces.internal.query.explainplan.ScanningInfo;
import com.gigaspaces.internal.query.explainplan.SingleExplainPlan;
import com.gigaspaces.internal.query.explainplan.TextReportFormatter;
import com.gigaspaces.internal.query.explainplan.UnionIndexInfo;
import com.gigaspaces.query.explainplan.ExplainPlan;
import com.j_spaces.core.client.SQLQuery;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ExperimentalApi
public class ExplainPlanImpl
implements ExplainPlan {
    private final SQLQuery<?> query;
    private final Map<String, SingleExplainPlan> plans = new HashMap<String, SingleExplainPlan>();
    private final IntegerObjectMap<String> indexInfoDescCache = CollectionsFactory.getInstance().createIntegerObjectMap();

    public ExplainPlanImpl(SQLQuery query) {
        this.query = query;
    }

    public static ExplainPlanImpl fromQueryPacket(Object query) {
        ExplainPlanImpl result = null;
        if (query instanceof QueryTemplatePacket) {
            result = (ExplainPlanImpl)((QueryTemplatePacket)query).getExplainPlan();
        }
        if (result != null) {
            result.reset();
        }
        return result;
    }

    public SingleExplainPlan getPlan(String partitionId) {
        return this.plans.get(partitionId);
    }

    public Map<String, SingleExplainPlan> getAllPlans() {
        return this.plans;
    }

    public void reset() {
        this.plans.clear();
        this.indexInfoDescCache.clear();
    }

    public void aggregate(SingleExplainPlan plan) {
        this.plans.put(plan.getPartitionId(), plan);
    }

    public String toString() {
        TextReportFormatter report = new TextReportFormatter();
        report.line("******************** Explain plan report ********************");
        this.append(report);
        report.line("*************************************************************");
        return report.toString();
    }

    protected void append(TextReportFormatter report) {
        report.line("Query: " + this.query.toString());
        if (this.plans.isEmpty()) {
            report.line("Not executed yet");
        } else {
            this.appendSummary(report);
            this.appendDetailed(report);
        }
    }

    protected void appendSummary(TextReportFormatter report) {
        report.line("Execution Information Summary:");
        report.indent();
        report.line("Total scanned partitions: " + this.plans.size());
        int totalScanned = 0;
        int totalMatched = 0;
        for (SingleExplainPlan plan : this.plans.values()) {
            for (ScanningInfo scanningInfo : plan.getScanningInfo().values()) {
                totalScanned += scanningInfo.getScanned().intValue();
                totalMatched += scanningInfo.getMatched().intValue();
            }
        }
        report.line("Total scanned entries: " + totalScanned);
        report.line("Total matched entries: " + totalMatched);
        report.unindent();
    }

    protected void appendDetailed(TextReportFormatter report) {
        this.indexInfoDescCache.clear();
        report.line("Detailed Execution Information:");
        report.indent();
        report.line("Query Tree:");
        report.indent();
        this.append(report, this.plans.values().iterator().next().getRoot());
        report.unindent();
        for (Map.Entry<String, SingleExplainPlan> entry : this.plans.entrySet()) {
            this.append(report, entry.getKey(), entry.getValue());
        }
        report.unindent();
    }

    protected void append(TextReportFormatter report, QueryOperationNode node) {
        report.line(node.toString());
        report.indent();
        for (QueryOperationNode subNode : node.getChildren()) {
            this.append(report, subNode);
        }
        report.unindent();
    }

    protected void append(TextReportFormatter report, String partitionId, SingleExplainPlan singleExplainPlan) {
        report.line("Partition Id: " + partitionId);
        Map<String, List<IndexChoiceNode>> indexesInfo = singleExplainPlan.getIndexesInfo();
        Map<String, ScanningInfo> scanningInfo = singleExplainPlan.getScanningInfo();
        if (indexesInfo.isEmpty()) {
            report.line("Index Information: NO INDEX USED");
            report.indent();
            for (Map.Entry<String, ScanningInfo> entry : scanningInfo.entrySet()) {
                report.line(entry.getKey() + ":");
                this.append(report, entry.getValue());
            }
            report.unindent();
        } else if (indexesInfo.size() == 1) {
            Map.Entry<String, List<IndexChoiceNode>> entry = indexesInfo.entrySet().iterator().next();
            ScanningInfo scanningInfoEntry = scanningInfo != null ? scanningInfo.get(entry.getKey()) : null;
            report.indent();
            this.append(report, null, entry.getValue(), scanningInfoEntry);
            report.unindent();
        } else {
            report.indent();
            for (Map.Entry<String, List<IndexChoiceNode>> entry : indexesInfo.entrySet()) {
                ScanningInfo scanningInfoEntry = scanningInfo != null ? scanningInfo.get(entry.getKey()) : null;
                this.append(report, entry.getKey(), entry.getValue(), scanningInfoEntry);
            }
            report.unindent();
        }
    }

    protected void append(TextReportFormatter report, String typeName, List<IndexChoiceNode> list, ScanningInfo scanningInfo) {
        if (typeName != null) {
            report.line("Type name: " + typeName);
            report.indent();
        }
        this.append(report, scanningInfo);
        report.line("Index scan report:");
        report.indent();
        for (int i = list.size() - 1; i >= 0; --i) {
            IndexChoiceNode node = list.get(i);
            report.line(node.getName());
            report.indent();
            report.line("Inspected: ");
            report.indent();
            for (IndexInfo option : node.getOptions()) {
                report.line("[" + this.getOptionDesc(option) + "] " + option.toString());
            }
            report.unindent();
            report.line("Selected: [" + this.getOptionDesc(node.getChosen()) + "] " + this.getSelectedDesc(node.getChosen()));
            report.unindent();
        }
        report.unindent();
        if (typeName != null) {
            report.unindent();
        }
    }

    private String getSelectedDesc(IndexInfo indexInfo) {
        if (indexInfo instanceof UnionIndexInfo) {
            List<IndexInfo> options = ((UnionIndexInfo)indexInfo).getOptions();
            if (options.size() == 0) {
                return "Union []";
            }
            StringBuilder sb = new StringBuilder();
            for (IndexInfo option : options) {
                sb.append(sb.length() == 0 ? "Union [" : ", ");
                sb.append(this.getOptionDesc(option));
            }
            sb.append("]");
            return sb.toString();
        }
        return indexInfo.toString();
    }

    protected void append(TextReportFormatter report, ScanningInfo scanningInfo) {
        Integer scanned = scanningInfo != null ? scanningInfo.getScanned() : 0;
        Integer matched = scanningInfo != null ? scanningInfo.getMatched() : 0;
        report.line("Scanned entries: " + scanned);
        report.line("Matched entries: " + matched);
    }

    private String getOptionDesc(IndexInfo indexInfo) {
        int id = System.identityHashCode(indexInfo);
        String desc = this.indexInfoDescCache.get(id);
        if (desc == null) {
            desc = "@" + (this.indexInfoDescCache.size() + 1);
            this.indexInfoDescCache.put(id, desc);
        }
        return desc;
    }
}

