/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.explainplan;

import com.gigaspaces.api.ExperimentalApi;
import com.gigaspaces.internal.query.AbstractQueryIndex;
import com.gigaspaces.internal.query.CompoundAndCustomQuery;
import com.gigaspaces.internal.query.CompoundContainsItemsCustomQuery;
import com.gigaspaces.internal.query.CompoundOrCustomQuery;
import com.gigaspaces.internal.query.ExactValueIndexScanner;
import com.gigaspaces.internal.query.IContainsItemsCustomQuery;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.query.InValueIndexScanner;
import com.gigaspaces.internal.query.NotRegexIndexScanner;
import com.gigaspaces.internal.query.NullValueIndexScanner;
import com.gigaspaces.internal.query.RangeIndexScanner;
import com.gigaspaces.internal.query.RegexIndexScanner;
import com.gigaspaces.internal.query.explainplan.BetweenIndexInfo;
import com.gigaspaces.internal.query.explainplan.BetweenRangeNode;
import com.gigaspaces.internal.query.explainplan.IndexInfo;
import com.gigaspaces.internal.query.explainplan.QueryJunctionNode;
import com.gigaspaces.internal.query.explainplan.QueryOperationNode;
import com.gigaspaces.internal.query.explainplan.QueryOperator;
import com.gigaspaces.internal.query.explainplan.QueryTypes;
import com.gigaspaces.internal.query.explainplan.RangeNode;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.jdbc.builder.QueryTemplatePacket;
import com.j_spaces.jdbc.builder.range.CompositeRange;
import com.j_spaces.jdbc.builder.range.ContainsCompositeRange;
import com.j_spaces.jdbc.builder.range.Range;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@ExperimentalApi
public class ExplainPlanUtil {
    public static IndexInfo createIndexInfo(AbstractQueryIndex abstractIndexScanner, TypeDataIndex index, TypeData typeData, int size, boolean usable) {
        if (index == null) {
            IndexInfo indexInfo = new IndexInfo();
            indexInfo.setUsable(false);
            return indexInfo;
        }
        if (abstractIndexScanner instanceof RangeIndexScanner) {
            RangeIndexScanner rangeIndexScanner = (RangeIndexScanner)abstractIndexScanner;
            QueryOperator operator = ExplainPlanUtil.getOperatorForRangeIndex(rangeIndexScanner.getMin(), rangeIndexScanner.getMax(), rangeIndexScanner.isIncludeMin(), rangeIndexScanner.isIncludeMax());
            if (operator == QueryOperator.BETWEEN) {
                return new BetweenIndexInfo(rangeIndexScanner.getIndexName(), size, index.getIndexType(), rangeIndexScanner.getMin(), rangeIndexScanner.isIncludeMin(), rangeIndexScanner.getMax(), rangeIndexScanner.isIncludeMax(), operator, usable);
            }
            if (rangeIndexScanner.getMin() != null) {
                return new IndexInfo(rangeIndexScanner.getIndexName(), size, index.getIndexType(), rangeIndexScanner.getMin(), operator, usable);
            }
            return new IndexInfo(rangeIndexScanner.getIndexName(), size, index.getIndexType(), rangeIndexScanner.getMax(), operator, usable);
        }
        if (abstractIndexScanner instanceof ExactValueIndexScanner) {
            return new IndexInfo(abstractIndexScanner.getIndexName(), size, index.getIndexType(), abstractIndexScanner.getIndexValue(), QueryOperator.EQ, usable);
        }
        if (abstractIndexScanner instanceof InValueIndexScanner) {
            ((InValueIndexScanner)abstractIndexScanner).get_indexInValueSet();
            return new IndexInfo(abstractIndexScanner.getIndexName(), size, index.getIndexType(), ((InValueIndexScanner)abstractIndexScanner).get_indexInValueSet(), QueryOperator.IN, usable);
        }
        if (abstractIndexScanner instanceof NotRegexIndexScanner) {
            return new IndexInfo(abstractIndexScanner.getIndexName(), size, index.getIndexType(), abstractIndexScanner.getIndexValue(), QueryOperator.NOT_REGEX, usable);
        }
        if (abstractIndexScanner instanceof RegexIndexScanner) {
            return new IndexInfo(abstractIndexScanner.getIndexName(), size, index.getIndexType(), abstractIndexScanner.getIndexValue(), QueryOperator.REGEX, usable);
        }
        if (abstractIndexScanner instanceof NullValueIndexScanner) {
            return new IndexInfo(abstractIndexScanner.getIndexName(), size, index.getIndexType(), abstractIndexScanner.getIndexValue(), QueryOperator.IS_NULL, usable);
        }
        return null;
    }

    private static QueryOperator getOperatorForRangeIndex(Comparable min, Comparable max, boolean includeMin, boolean includeMax) {
        QueryOperator operator = null;
        if (max != null) {
            operator = min != null ? QueryOperator.BETWEEN : (includeMax ? QueryOperator.LE : QueryOperator.LT);
        } else if (min != null) {
            operator = includeMin ? QueryOperator.GE : QueryOperator.GT;
        }
        return operator;
    }

    public static QueryOperationNode BuildMatchCodes(QueryTemplatePacket packet) {
        QueryJunctionNode and = new QueryJunctionNode("AND");
        Object[] fieldValues = packet.getFieldValues();
        short[] extendedMatchCodes = packet.getExtendedMatchCodes();
        Object[] rangeValues = packet.getRangeValues();
        String[] propertiesNames = packet.getTypeDescriptor().getPropertiesNames();
        boolean[] valuesInclusion = packet.getRangeValuesInclusion();
        for (int i = 0; i < fieldValues.length; ++i) {
            if (fieldValues[i] == null) continue;
            if (rangeValues == null) {
                and.getChildren().add(ExplainPlanUtil.getMatchNode(propertiesNames[i], fieldValues[i], ExplainPlanUtil.getQueryOperator(extendedMatchCodes[i]), null, false));
                continue;
            }
            and.getChildren().add(ExplainPlanUtil.getMatchNode(propertiesNames[i], fieldValues[i], ExplainPlanUtil.getQueryOperator(extendedMatchCodes[i]), rangeValues[i], valuesInclusion[i]));
        }
        return and;
    }

    private static QueryOperationNode getMatchNode(String propertyName, Object fieldValue, QueryOperator queryOperator, Object rangeValue, boolean includeRangeValue) {
        if (rangeValue == null) {
            return new RangeNode(propertyName, fieldValue, queryOperator, null);
        }
        switch (queryOperator) {
            case GT: {
                return new BetweenRangeNode(propertyName, QueryOperator.BETWEEN, null, (Comparable)fieldValue, false, (Comparable)rangeValue, includeRangeValue);
            }
            case GE: {
                return new BetweenRangeNode(propertyName, QueryOperator.BETWEEN, null, (Comparable)fieldValue, true, (Comparable)rangeValue, includeRangeValue);
            }
            case LT: {
                return new BetweenRangeNode(propertyName, QueryOperator.BETWEEN, null, (Comparable)rangeValue, includeRangeValue, (Comparable)fieldValue, false);
            }
            case LE: {
                return new BetweenRangeNode(propertyName, QueryOperator.BETWEEN, null, (Comparable)rangeValue, includeRangeValue, (Comparable)fieldValue, true);
            }
        }
        return null;
    }

    public static QueryOperator getQueryOperator(short extendedMatchCode) {
        switch (extendedMatchCode) {
            case 0: {
                return QueryOperator.EQ;
            }
            case 1: {
                return QueryOperator.NE;
            }
            case 2: {
                return QueryOperator.GT;
            }
            case 3: {
                return QueryOperator.GE;
            }
            case 4: {
                return QueryOperator.LT;
            }
            case 5: {
                return QueryOperator.LE;
            }
            case 6: {
                return QueryOperator.IS_NULL;
            }
            case 7: {
                return QueryOperator.NOT_NULL;
            }
            case 8: {
                return QueryOperator.REGEX;
            }
            case 9: {
                return QueryOperator.CONTAINS_TOKEN;
            }
            case 10: {
                return QueryOperator.NOT_REGEX;
            }
            case 11: {
                return QueryOperator.IN;
            }
        }
        return QueryOperator.NOT_SUPPORTED;
    }

    public static QueryOperationNode buildQueryTree(ICustomQuery customQuery) {
        QueryOperationNode currentNode = QueryTypes.getNode(customQuery);
        List<ICustomQuery> subQueries = ExplainPlanUtil.getSubQueries(customQuery);
        if (subQueries == null) {
            return currentNode;
        }
        ArrayList<ICustomQuery> finalSubqueries = new ArrayList<ICustomQuery>();
        finalSubqueries.addAll(subQueries);
        for (ICustomQuery subQuery : subQueries) {
            if (!(subQuery instanceof ContainsCompositeRange) && !(subQuery instanceof CompositeRange)) continue;
            finalSubqueries.remove(subQuery);
            finalSubqueries.addAll(ExplainPlanUtil.getSubQueries(subQuery));
        }
        for (ICustomQuery subQuery : finalSubqueries) {
            QueryOperationNode son = ExplainPlanUtil.buildQueryTree(subQuery);
            currentNode.getChildren().add(son);
        }
        return currentNode;
    }

    public static List<ICustomQuery> getSubQueries(ICustomQuery customQuery) {
        if (customQuery instanceof CompoundContainsItemsCustomQuery) {
            return ExplainPlanUtil.compoundConvertList(((CompoundContainsItemsCustomQuery)customQuery).getSubQueries());
        }
        if (customQuery instanceof CompoundAndCustomQuery) {
            return ((CompoundAndCustomQuery)customQuery).get_subQueries();
        }
        if (customQuery instanceof CompoundOrCustomQuery) {
            return ((CompoundOrCustomQuery)customQuery).get_subQueries();
        }
        if (customQuery instanceof CompositeRange) {
            return ExplainPlanUtil.rangeConvertList(((CompositeRange)customQuery).get_ranges());
        }
        return null;
    }

    public static List<ICustomQuery> rangeConvertList(LinkedList<Range> ranges) {
        ArrayList<ICustomQuery> res = new ArrayList<ICustomQuery>();
        for (Range range : ranges) {
            res.add(range);
        }
        return res;
    }

    public static List<ICustomQuery> compoundConvertList(List<IContainsItemsCustomQuery> subQueries) {
        ArrayList<ICustomQuery> res = new ArrayList<ICustomQuery>();
        for (IContainsItemsCustomQuery subQuery : subQueries) {
            res.add(subQuery);
        }
        return res;
    }
}

