/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.explainplan;

import com.gigaspaces.api.ExperimentalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.explainplan.IndexInfo;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

@ExperimentalApi
public class IndexChoiceNode
implements Externalizable {
    private String name;
    private List<IndexInfo> options;
    private IndexInfo chosen;

    public IndexChoiceNode(String name) {
        this.name = name;
        this.options = new ArrayList<IndexInfo>();
    }

    public IndexChoiceNode(String name, List<IndexInfo> options, IndexInfo chosen) {
        this.name = name;
        this.options = options;
        this.chosen = chosen;
    }

    public IndexChoiceNode() {
        this.options = new ArrayList<IndexInfo>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<IndexInfo> getOptions() {
        return this.options;
    }

    public void addOption(IndexInfo option) {
        this.options.add(option);
    }

    public IndexInfo getChosen() {
        return this.chosen;
    }

    public void setChosen(IndexInfo chosen) {
        this.chosen = chosen;
    }

    public IndexInfo getOptionByName(String name) {
        for (IndexInfo indexInfo : this.options) {
            if (!indexInfo.getName().equals(name)) continue;
            return indexInfo;
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        IOUtils.writeString(objectOutput, this.name);
        this.writeList(objectOutput, this.options);
        objectOutput.writeObject(this.chosen);
    }

    private void writeList(ObjectOutput objectOutput, List<IndexInfo> options) throws IOException {
        int size = options.size();
        objectOutput.writeInt(size);
        for (IndexInfo option : options) {
            objectOutput.writeObject(option);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.name = IOUtils.readString(objectInput);
        this.options = this.readList(objectInput);
        this.chosen = (IndexInfo)objectInput.readObject();
    }

    private List<IndexInfo> readList(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        ArrayList<IndexInfo> res = new ArrayList<IndexInfo>();
        int size = objectInput.readInt();
        for (int i = 0; i < size; ++i) {
            res.add((IndexInfo)objectInput.readObject());
        }
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexChoiceNode that = (IndexChoiceNode)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.options != null ? !this.options.equals(that.options) : that.options != null) {
            return false;
        }
        return !(this.chosen == null ? that.chosen != null : !this.chosen.equals(that.chosen));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        result = 31 * result + (this.chosen != null ? this.chosen.hashCode() : 0);
        return result;
    }
}

