/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.explainplan;

import com.gigaspaces.api.ExperimentalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.explainplan.QueryOperator;
import com.gigaspaces.metadata.index.SpaceIndexType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@ExperimentalApi
public class IndexInfo
implements Externalizable {
    private String name;
    private Integer size;
    private SpaceIndexType type;
    private Object value;
    private QueryOperator operator;
    private boolean usable;

    public IndexInfo() {
    }

    public IndexInfo(String name, Integer size, SpaceIndexType type, Object value, QueryOperator operator) {
        this.name = name;
        this.size = size;
        this.type = type;
        this.value = value;
        this.operator = operator;
        if (type.isOrdered()) {
            this.size = -1;
        }
        this.usable = true;
    }

    public IndexInfo(String name, Integer size, SpaceIndexType type, Object value, QueryOperator operator, boolean usable) {
        this.name = name;
        this.size = size;
        this.type = type;
        this.value = value;
        this.operator = operator;
        this.usable = usable;
    }

    public IndexInfo(String name) {
    }

    public QueryOperator getOperator() {
        return this.operator;
    }

    public void setOperator(QueryOperator operator) {
        this.operator = operator;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getSize() {
        return this.size;
    }

    protected String getSizeDesc() {
        return this.size == null || this.size == -1 ? "unknown" : String.valueOf(this.size);
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setType(SpaceIndexType type) {
        this.type = type;
    }

    public SpaceIndexType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean isUsable() {
        return this.usable;
    }

    public void setUsable(boolean usable) {
        this.usable = usable;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        IOUtils.writeString(objectOutput, this.name);
        objectOutput.writeObject(this.size);
        objectOutput.writeObject((Object)this.type);
        objectOutput.writeObject(this.value);
        objectOutput.writeObject((Object)this.operator);
        objectOutput.writeBoolean(this.usable);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.name = IOUtils.readString(objectInput);
        this.size = (Integer)objectInput.readObject();
        this.type = (SpaceIndexType)((Object)objectInput.readObject());
        this.value = objectInput.readObject();
        this.operator = (QueryOperator)((Object)objectInput.readObject());
        this.usable = objectInput.readBoolean();
    }

    public String toString() {
        return this.getCriteriaDesc() + ", size=" + this.getSizeDesc() + ", type=" + (Object)((Object)this.getType()) + (this.isUsable() ? "" : ", UNUSABLE");
    }

    protected String getCriteriaDesc() {
        return (Object)((Object)this.operator) + "(" + this.name + ", " + this.value + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexInfo indexInfo = (IndexInfo)o;
        if (this.name != null ? !this.name.equals(indexInfo.name) : indexInfo.name != null) {
            return false;
        }
        if (this.size != null ? !this.size.equals(indexInfo.size) : indexInfo.size != null) {
            return false;
        }
        if (this.type != indexInfo.type) {
            return false;
        }
        if (this.value != null ? !this.value.equals(indexInfo.value) : indexInfo.value != null) {
            return false;
        }
        return this.operator == indexInfo.operator;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        return result;
    }
}

