/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.explainplan;

import com.gigaspaces.api.ExperimentalApi;
import com.gigaspaces.internal.query.explainplan.QueryOperationNode;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

@ExperimentalApi
public class QueryJunctionNode
implements QueryOperationNode {
    private String name;
    private final List<QueryOperationNode> subTrees = new ArrayList<QueryOperationNode>();

    public QueryJunctionNode() {
    }

    public QueryJunctionNode(String name) {
        this.name = name;
    }

    @Override
    public List<QueryOperationNode> getChildren() {
        return this.subTrees;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeInt(this.subTrees.size());
        for (QueryOperationNode subTree : this.subTrees) {
            out.writeObject(subTree);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.subTrees.add((QueryOperationNode)in.readObject());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryJunctionNode that = (QueryJunctionNode)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.subTrees != null ? this.subTrees.equals(that.subTrees) : that.subTrees == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.subTrees != null ? this.subTrees.hashCode() : 0);
        return result;
    }
}

