/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.explainplan;

import com.gigaspaces.api.ExperimentalApi;
import com.gigaspaces.internal.query.explainplan.QueryOperationNode;
import com.gigaspaces.internal.query.explainplan.QueryOperator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;

@ExperimentalApi
public class RangeNode
implements QueryOperationNode {
    private String fieldName;
    private Object value;
    private QueryOperator operator;
    private String functionName;

    public RangeNode() {
    }

    public RangeNode(String fieldName, Object value, QueryOperator operator, String functionName) {
        this.fieldName = fieldName;
        this.value = value;
        this.operator = operator;
        this.functionName = functionName;
    }

    @Override
    public List<QueryOperationNode> getChildren() {
        return Collections.emptyList();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public QueryOperator getOperator() {
        return this.operator;
    }

    public void setOperator(QueryOperator operator) {
        this.operator = operator;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String toString() {
        return this.operator.toString() + '(' + (this.functionName != null ? this.functionName : this.fieldName) + ", " + this.value + ')';
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fieldName);
        out.writeObject(this.value);
        out.writeObject((Object)this.operator);
        out.writeObject(this.functionName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fieldName = (String)in.readObject();
        this.value = in.readObject();
        this.operator = (QueryOperator)((Object)in.readObject());
        this.functionName = (String)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeNode rangeNode = (RangeNode)o;
        if (this.fieldName != null ? !this.fieldName.equals(rangeNode.fieldName) : rangeNode.fieldName != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(rangeNode.value) : rangeNode.value != null) {
            return false;
        }
        if (this.operator != rangeNode.operator) {
            return false;
        }
        return this.functionName != null ? this.functionName.equals(rangeNode.functionName) : rangeNode.functionName == null;
    }

    public int hashCode() {
        int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.functionName != null ? this.functionName.hashCode() : 0);
        return result;
    }
}

