/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.explainplan;

import com.gigaspaces.api.ExperimentalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.SpaceCollectionIndex;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.query.explainplan.ExplainPlanUtil;
import com.gigaspaces.internal.query.explainplan.IndexChoiceNode;
import com.gigaspaces.internal.query.explainplan.QueryOperationNode;
import com.gigaspaces.internal.query.explainplan.ScanningInfo;
import com.gigaspaces.metadata.index.CompoundIndex;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.j_spaces.core.client.Modifiers;
import com.j_spaces.jdbc.builder.range.IsNullRange;
import com.j_spaces.jdbc.builder.range.NotNullRange;
import com.j_spaces.jdbc.builder.range.NotRegexRange;
import com.j_spaces.jdbc.builder.range.Range;
import com.j_spaces.jdbc.builder.range.RegexRange;
import com.j_spaces.jdbc.builder.range.RelationRange;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ExperimentalApi
public class SingleExplainPlan
implements Externalizable {
    private String partitionId;
    private QueryOperationNode root;
    private Map<String, List<IndexChoiceNode>> indexesInfo;
    private Map<String, ScanningInfo> scanningInfo = new HashMap<String, ScanningInfo>();

    public SingleExplainPlan() {
        this.indexesInfo = new HashMap<String, List<IndexChoiceNode>>();
    }

    public SingleExplainPlan(ICustomQuery customQuery) {
        this.indexesInfo = new HashMap<String, List<IndexChoiceNode>>();
        this.root = ExplainPlanUtil.buildQueryTree(customQuery);
    }

    public void setPartitionId(String partitionId) {
        this.partitionId = partitionId;
    }

    public void setRoot(QueryOperationNode root) {
        this.root = root;
    }

    public void setIndexesInfo(Map<String, List<IndexChoiceNode>> indexesInfo) {
        this.indexesInfo = indexesInfo;
    }

    public void setScanningInfo(Map<String, ScanningInfo> scanningInfo) {
        this.scanningInfo = scanningInfo;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public QueryOperationNode getRoot() {
        return this.root;
    }

    public Map<String, List<IndexChoiceNode>> getIndexesInfo() {
        return this.indexesInfo;
    }

    public Map<String, ScanningInfo> getScanningInfo() {
        return this.scanningInfo;
    }

    public void addIndexesInfo(String type, List<IndexChoiceNode> scanSelectionTree) {
        this.indexesInfo.put(type, scanSelectionTree);
    }

    public void addScanIndexChoiceNode(String clazz, IndexChoiceNode indexChoiceNode) {
        if (!this.indexesInfo.containsKey(clazz)) {
            ArrayList scanSelectionTree = new ArrayList();
            this.indexesInfo.put(clazz, scanSelectionTree);
        }
        this.indexesInfo.get(clazz).add(indexChoiceNode);
    }

    public List<IndexChoiceNode> getScanSelectionTree(String clazz) {
        return this.indexesInfo.get(clazz);
    }

    public IndexChoiceNode getLatestIndexChoiceNode(String clazz) {
        if (this.indexesInfo.size() == 0) {
            return null;
        }
        List<IndexChoiceNode> scanSelectionTree = this.indexesInfo.get(clazz);
        return scanSelectionTree.get(scanSelectionTree.size() - 1);
    }

    public Integer getNumberOfScannedEntries(String clazz) {
        return this.scanningInfo.get(clazz).getScanned();
    }

    public Integer getNumberOfMatchedEntries(String clazz) {
        return this.scanningInfo.get(clazz).getMatched();
    }

    public void incrementScanned(String clazz) {
        ScanningInfo info;
        if (!this.scanningInfo.containsKey(clazz)) {
            info = new ScanningInfo();
            this.scanningInfo.put(clazz, info);
        }
        info = this.scanningInfo.get(clazz);
        info.setScanned(info.getScanned() + 1);
    }

    public void incrementMatched(String clazz) {
        ScanningInfo info;
        if (!this.scanningInfo.containsKey(clazz)) {
            info = new ScanningInfo();
            this.scanningInfo.put(clazz, info);
        }
        info = this.scanningInfo.get(clazz);
        info.setMatched(info.getMatched() + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SingleExplainPlan)) {
            return false;
        }
        SingleExplainPlan that = (SingleExplainPlan)o;
        if (this.partitionId != null ? !this.partitionId.equals(that.partitionId) : that.partitionId != null) {
            return false;
        }
        if (this.root != null ? !this.root.equals(that.root) : that.root != null) {
            return false;
        }
        if (this.indexesInfo != null ? !this.indexesInfo.equals(that.indexesInfo) : that.indexesInfo != null) {
            return false;
        }
        return this.scanningInfo != null ? this.scanningInfo.equals(that.scanningInfo) : that.scanningInfo == null;
    }

    public int hashCode() {
        int result = this.partitionId != null ? this.partitionId.hashCode() : 0;
        result = 31 * result + (this.root != null ? this.root.hashCode() : 0);
        result = 31 * result + (this.indexesInfo != null ? this.indexesInfo.hashCode() : 0);
        result = 31 * result + (this.scanningInfo != null ? this.scanningInfo.hashCode() : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.root);
        IOUtils.writeString(objectOutput, this.partitionId);
        this.writeIndexes(objectOutput);
        this.writeScannigInfo(objectOutput);
    }

    private void writeScannigInfo(ObjectOutput objectOutput) throws IOException {
        int length = this.scanningInfo.size();
        objectOutput.writeInt(length);
        for (Map.Entry<String, ScanningInfo> entry : this.scanningInfo.entrySet()) {
            objectOutput.writeObject(entry.getKey());
            objectOutput.writeObject(entry.getValue());
        }
    }

    private void writeIndexes(ObjectOutput objectOutput) throws IOException {
        int length = this.indexesInfo.size();
        objectOutput.writeInt(length);
        for (Map.Entry<String, List<IndexChoiceNode>> entry : this.indexesInfo.entrySet()) {
            objectOutput.writeObject(entry.getKey());
            if (entry.getValue() == null) {
                objectOutput.writeInt(-1);
                continue;
            }
            int listLength = entry.getValue().size();
            objectOutput.writeInt(listLength);
            for (int i = 0; i < listLength; ++i) {
                objectOutput.writeObject(entry.getValue().get(i));
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.root = (QueryOperationNode)objectInput.readObject();
        this.partitionId = IOUtils.readString(objectInput);
        this.indexesInfo = this.readIndexes(objectInput);
        this.scanningInfo = this.readScanningInfo(objectInput);
    }

    private Map<String, ScanningInfo> readScanningInfo(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int length = objectInput.readInt();
        HashMap<String, ScanningInfo> map = new HashMap<String, ScanningInfo>();
        for (int i = 0; i < length; ++i) {
            String key = (String)objectInput.readObject();
            ScanningInfo val = (ScanningInfo)objectInput.readObject();
            map.put(key, val);
        }
        return map;
    }

    private Map<String, List<IndexChoiceNode>> readIndexes(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        HashMap map = null;
        int length = objectInput.readInt();
        if (length >= 0) {
            map = new HashMap(length);
            for (int i = 0; i < length; ++i) {
                String key = (String)objectInput.readObject();
                ArrayList<IndexChoiceNode> list = null;
                int listLength = objectInput.readInt();
                if (listLength >= 0) {
                    list = new ArrayList<IndexChoiceNode>(listLength);
                    for (int j = 0; j < listLength; ++j) {
                        list.add((IndexChoiceNode)objectInput.readObject());
                    }
                }
                map.put(key, list);
            }
        }
        return map;
    }

    public static void validate(long timeout, boolean blobStoreCachePolicy, int operationModifiers, ICustomQuery customQuery, Map<String, SpaceIndex> indexes) {
        if (timeout != 0L) {
            throw new UnsupportedOperationException("Sql explain plan does not support timeout operations");
        }
        if (blobStoreCachePolicy) {
            throw new UnsupportedOperationException("Sql explain plan does not support off-heap cache policy");
        }
        if (Modifiers.contains(operationModifiers, 0x100000)) {
            throw new UnsupportedOperationException("Sql explain plan does not support FIFO grouping");
        }
        if (customQuery != null) {
            SingleExplainPlan.validateQueryTypes(customQuery);
        }
        SingleExplainPlan.validateIndexesTypes(indexes);
    }

    private static void validateIndexesTypes(Map<String, SpaceIndex> indexMap) {
        for (SpaceIndex spaceIndex : indexMap.values()) {
            if (spaceIndex instanceof CompoundIndex) {
                throw new UnsupportedOperationException("Sql explain plan does not support compound index");
            }
            if (!(spaceIndex instanceof SpaceCollectionIndex)) continue;
            throw new UnsupportedOperationException("Sql explain plan does not support collection index");
        }
    }

    private static void validateQueryTypes(ICustomQuery customQuery) {
        if (customQuery instanceof RelationRange) {
            throw new UnsupportedOperationException("Sql explain plan does not support geo-spatial type queries");
        }
        if (customQuery instanceof RegexRange || customQuery instanceof NotRegexRange) {
            throw new UnsupportedOperationException("Sql explain plan does not support regular expression type queries");
        }
        if (customQuery instanceof IsNullRange || customQuery instanceof NotNullRange) {
            throw new UnsupportedOperationException("Sql explain plan does not support is null / is not null type queries");
        }
        if (customQuery instanceof Range && ((Range)customQuery).getFunctionCallDescription() != null) {
            throw new UnsupportedOperationException("Sql explain plan does not support sql function type queries");
        }
        if (ExplainPlanUtil.getSubQueries(customQuery) != null) {
            for (ICustomQuery subQuery : ExplainPlanUtil.getSubQueries(customQuery)) {
                SingleExplainPlan.validateQueryTypes(subQuery);
            }
        }
    }
}

