/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.explainplan;

import com.gigaspaces.api.ExperimentalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.explainplan.IndexInfo;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

@ExperimentalApi
public class UnionIndexInfo
extends IndexInfo {
    private List<IndexInfo> options;

    public UnionIndexInfo() {
    }

    public UnionIndexInfo(List<IndexInfo> options) {
        this.options = options;
        this.initialize(options);
    }

    public List<IndexInfo> getOptions() {
        return this.options;
    }

    private void initialize(List<IndexInfo> options) {
        StringBuilder name = new StringBuilder("[");
        Integer size = 0;
        if (options.size() > 0) {
            for (IndexInfo option : options) {
                String optionName = "(" + option.getName() + " " + (Object)((Object)option.getOperator()) + " " + option.getValue() + ")";
                name.append(optionName).append(", ");
                if (option.getSize() < 0) {
                    size = -1;
                    break;
                }
                size = size + option.getSize();
            }
            name.deleteCharAt(name.length() - 1);
            name.deleteCharAt(name.length() - 1);
        }
        name.append("]");
        this.setName(name.toString());
        this.setSize(size);
        this.setUsable(true);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeList(out, this.options);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.options = IOUtils.readList(in);
        this.initialize(this.options);
    }

    @Override
    public String toString() {
        return "Union [size=" + this.getSizeDesc() + (this.getSize() > 0 ? ", " + this.getName() : "") + "]";
    }
}

