/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.predicate;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.query.predicate.FalseSpacePredicate;
import com.gigaspaces.internal.query.predicate.ISpacePredicate;
import com.gigaspaces.internal.query.predicate.TrueSpacePredicate;
import com.gigaspaces.internal.query.predicate.ValueGetterSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.BetweenSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.EqualsSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.GreaterEqualsSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.GreaterSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.InSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.LessEqualsSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.LessSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.NotEqualsSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.NotNullSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.NullSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.RegexSpacePredicate;
import com.gigaspaces.internal.query.predicate.composite.AllSpacePredicate;
import com.gigaspaces.internal.query.predicate.composite.AndSpacePredicate;
import com.gigaspaces.internal.query.predicate.composite.AnySpacePredicate;
import com.gigaspaces.internal.query.predicate.composite.NotSpacePredicate;
import com.gigaspaces.internal.query.predicate.composite.OrSpacePredicate;
import com.gigaspaces.internal.query.predicate.composite.XorSpacePredicate;
import com.gigaspaces.internal.query.valuegetter.SpaceEntryPathGetter;
import com.gigaspaces.internal.query.valuegetter.SpaceEntryPropertyGetter;
import com.gigaspaces.server.ServerEntry;

@InternalApi
public class SpacePredicates {
    public static final FalseSpacePredicate FALSE = new FalseSpacePredicate();
    public static final TrueSpacePredicate TRUE = new TrueSpacePredicate();
    public static final NullSpacePredicate NULL = new NullSpacePredicate();
    public static final NotNullSpacePredicate NOT_NULL = new NotNullSpacePredicate();

    public static NotSpacePredicate not(ISpacePredicate predicate) {
        return new NotSpacePredicate(predicate);
    }

    public static AndSpacePredicate and(ISpacePredicate leftPredicate, ISpacePredicate rightPredicate) {
        return new AndSpacePredicate(leftPredicate, rightPredicate);
    }

    public static OrSpacePredicate or(ISpacePredicate leftPredicate, ISpacePredicate rightPredicate) {
        return new OrSpacePredicate(leftPredicate, rightPredicate);
    }

    public static XorSpacePredicate xor(ISpacePredicate leftPredicate, ISpacePredicate rightPredicate) {
        return new XorSpacePredicate(leftPredicate, rightPredicate);
    }

    public static AllSpacePredicate all(ISpacePredicate ... predicates) {
        return new AllSpacePredicate(predicates);
    }

    public static AnySpacePredicate any(ISpacePredicate ... predicates) {
        return new AnySpacePredicate(predicates);
    }

    public static NullSpacePredicate isNull() {
        return NULL;
    }

    public static NotNullSpacePredicate isNotNull() {
        return NOT_NULL;
    }

    public static EqualsSpacePredicate equal(Object value) {
        return new EqualsSpacePredicate(value);
    }

    public static NotEqualsSpacePredicate notEqual(Object value) {
        return new NotEqualsSpacePredicate(value);
    }

    public static GreaterSpacePredicate greater(Comparable<?> value) {
        return new GreaterSpacePredicate(value);
    }

    public static GreaterEqualsSpacePredicate greaterEqual(Comparable<?> value) {
        return new GreaterEqualsSpacePredicate(value);
    }

    public static LessSpacePredicate less(Comparable<?> value) {
        return new LessSpacePredicate(value);
    }

    public static LessEqualsSpacePredicate lessEqual(Comparable<?> value) {
        return new LessEqualsSpacePredicate(value);
    }

    public static BetweenSpacePredicate between(Comparable<?> low, Comparable<?> high) {
        return new BetweenSpacePredicate(low, high);
    }

    public static InSpacePredicate in(Object ... values) {
        return new InSpacePredicate(values);
    }

    public static RegexSpacePredicate regex(String pattern) {
        return new RegexSpacePredicate(pattern);
    }

    public static ValueGetterSpacePredicate<ServerEntry> property(String propertyName, ISpacePredicate predicate) {
        return new ValueGetterSpacePredicate<ServerEntry>(new SpaceEntryPropertyGetter(propertyName), predicate);
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyNull(String propertyName) {
        return SpacePredicates.property(propertyName, SpacePredicates.isNull());
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyNotNull(String propertyName) {
        return SpacePredicates.property(propertyName, SpacePredicates.isNotNull());
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyNot(String propertyName, ISpacePredicate predicate) {
        return SpacePredicates.property(propertyName, SpacePredicates.not(predicate));
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyAnd(String propertyName, ISpacePredicate leftPredicate, ISpacePredicate rightPredicate) {
        return SpacePredicates.property(propertyName, SpacePredicates.and(leftPredicate, rightPredicate));
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyXor(String propertyName, ISpacePredicate leftPredicate, ISpacePredicate rightPredicate) {
        return SpacePredicates.property(propertyName, SpacePredicates.xor(leftPredicate, rightPredicate));
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyOr(String propertyName, ISpacePredicate leftPredicate, ISpacePredicate rightPredicate) {
        return SpacePredicates.property(propertyName, SpacePredicates.or(leftPredicate, rightPredicate));
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyAll(String propertyName, ISpacePredicate ... predicates) {
        return SpacePredicates.property(propertyName, SpacePredicates.all(predicates));
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyAny(String propertyName, ISpacePredicate ... predicates) {
        return SpacePredicates.property(propertyName, SpacePredicates.any(predicates));
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyEqual(String propertyName, Object value) {
        return SpacePredicates.property(propertyName, SpacePredicates.equal(value));
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyNotEqual(String propertyName, Object value) {
        return SpacePredicates.property(propertyName, SpacePredicates.notEqual(value));
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyGreater(String propertyName, Comparable<?> value) {
        return SpacePredicates.property(propertyName, SpacePredicates.greater(value));
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyGreaterEqual(String propertyName, Comparable<?> value) {
        return SpacePredicates.property(propertyName, SpacePredicates.greaterEqual(value));
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyLess(String propertyName, Comparable<?> value) {
        return SpacePredicates.property(propertyName, SpacePredicates.less(value));
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyLessEqual(String propertyName, Comparable<?> value) {
        return SpacePredicates.property(propertyName, SpacePredicates.lessEqual(value));
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyBetween(String propertyName, Comparable<?> low, Comparable<?> high) {
        return SpacePredicates.property(propertyName, SpacePredicates.between(low, high));
    }

    public static ValueGetterSpacePredicate<ServerEntry> propertyIn(String propertyName, Object ... values) {
        return SpacePredicates.property(propertyName, SpacePredicates.in(values));
    }

    public static ValueGetterSpacePredicate<ServerEntry> path(String path, ISpacePredicate predicate) {
        return new ValueGetterSpacePredicate<ServerEntry>(new SpaceEntryPathGetter(path), predicate);
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathNull(String path) {
        return SpacePredicates.path(path, SpacePredicates.isNull());
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathNotNull(String path) {
        return SpacePredicates.path(path, SpacePredicates.isNotNull());
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathNot(String path, ISpacePredicate predicate) {
        return SpacePredicates.path(path, SpacePredicates.not(predicate));
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathAnd(String path, ISpacePredicate leftPredicate, ISpacePredicate rightPredicate) {
        return SpacePredicates.path(path, SpacePredicates.and(leftPredicate, rightPredicate));
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathOr(String path, ISpacePredicate leftPredicate, ISpacePredicate rightPredicate) {
        return SpacePredicates.path(path, SpacePredicates.or(leftPredicate, rightPredicate));
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathXor(String path, ISpacePredicate leftPredicate, ISpacePredicate rightPredicate) {
        return SpacePredicates.path(path, SpacePredicates.xor(leftPredicate, rightPredicate));
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathAll(String path, ISpacePredicate ... predicates) {
        return SpacePredicates.path(path, SpacePredicates.all(predicates));
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathAny(String path, ISpacePredicate ... predicates) {
        return SpacePredicates.path(path, SpacePredicates.any(predicates));
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathEqual(String path, Object value) {
        return SpacePredicates.path(path, SpacePredicates.equal(value));
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathNotEqual(String path, Object value) {
        return SpacePredicates.path(path, SpacePredicates.notEqual(value));
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathGreater(String path, Comparable<?> value) {
        return SpacePredicates.path(path, SpacePredicates.greater(value));
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathGreaterEqual(String path, Comparable<?> value) {
        return SpacePredicates.path(path, SpacePredicates.greaterEqual(value));
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathLess(String path, Comparable<?> value) {
        return SpacePredicates.path(path, SpacePredicates.less(value));
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathLessEqual(String path, Comparable<?> value) {
        return SpacePredicates.path(path, SpacePredicates.lessEqual(value));
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathBetween(String path, Comparable<?> low, Comparable<?> high) {
        return SpacePredicates.path(path, SpacePredicates.between(low, high));
    }

    public static ValueGetterSpacePredicate<ServerEntry> pathIn(String path, Object ... values) {
        return SpacePredicates.path(path, SpacePredicates.in(values));
    }
}

