/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.predicate;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.predicate.AbstractSpacePredicate;
import com.gigaspaces.internal.query.predicate.ISpacePredicate;
import com.gigaspaces.internal.query.valuegetter.ISpaceValueGetter;
import com.gigaspaces.internal.utils.ObjectUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ValueGetterSpacePredicate<T>
extends AbstractSpacePredicate {
    private static final long serialVersionUID = 1L;
    private ISpaceValueGetter<T> _valueGetter;
    private ISpacePredicate _predicate;

    public ValueGetterSpacePredicate() {
    }

    public ValueGetterSpacePredicate(ISpaceValueGetter<T> valueGetter, ISpacePredicate predicate) {
        this._valueGetter = valueGetter;
        this._predicate = predicate;
    }

    public ISpaceValueGetter<?> getValueGetter() {
        return this._valueGetter;
    }

    public ISpacePredicate getPredicate() {
        return this._predicate;
    }

    @Override
    public boolean execute(Object target) {
        Object value = this._valueGetter.getValue(target);
        return this._predicate.execute(value);
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ValueGetterSpacePredicate other = (ValueGetterSpacePredicate)obj;
        if (!ObjectUtils.equals(this.getValueGetter(), other.getValueGetter())) {
            return false;
        }
        return ObjectUtils.equals(this.getPredicate(), other.getPredicate());
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._valueGetter = (ISpaceValueGetter)IOUtils.readObject(in);
        this._predicate = (ISpacePredicate)IOUtils.readObject(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeObject(out, this._valueGetter);
        IOUtils.writeObject(out, this._predicate);
    }
}

