/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.predicate.comparison;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.predicate.AbstractSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.ComparableScalarSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.GreaterEqualsSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.GreaterSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.LessEqualsSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.LessSpacePredicate;
import com.gigaspaces.internal.utils.ObjectUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;

@InternalApi
public class BetweenSpacePredicate
extends AbstractSpacePredicate {
    private static final long serialVersionUID = 1L;
    private ComparableScalarSpacePredicate _lowPredicate;
    private ComparableScalarSpacePredicate _highPredicate;

    public BetweenSpacePredicate() {
    }

    public BetweenSpacePredicate(Comparable<?> low, Comparable<?> high) {
        this(low, high, null, true, true);
    }

    public BetweenSpacePredicate(Comparable<?> low, Comparable<?> high, Comparator<?> comparator) {
        this(low, high, comparator, true, true);
    }

    public BetweenSpacePredicate(Comparable<?> low, Comparable<?> high, boolean lowInclusive, boolean highInclusive) {
        this(low, high, null, lowInclusive, highInclusive);
    }

    public BetweenSpacePredicate(Comparable<?> low, Comparable<?> high, Comparator<?> comparator, boolean lowInclusive, boolean highInclusive) {
        this._lowPredicate = lowInclusive ? new GreaterEqualsSpacePredicate(low, comparator) : new GreaterSpacePredicate(low, comparator);
        this._highPredicate = highInclusive ? new LessEqualsSpacePredicate(high, comparator) : new LessSpacePredicate(high, comparator);
    }

    public ComparableScalarSpacePredicate getLowPredicate() {
        return this._lowPredicate;
    }

    public ComparableScalarSpacePredicate getHighPredicate() {
        return this._highPredicate;
    }

    @Override
    public boolean execute(Object target) {
        return this._lowPredicate.execute(target) && this._highPredicate.execute(target);
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        BetweenSpacePredicate other = (BetweenSpacePredicate)obj;
        if (!ObjectUtils.equals(this.getLowPredicate(), other.getLowPredicate())) {
            return false;
        }
        return ObjectUtils.equals(this.getHighPredicate(), other.getHighPredicate());
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._lowPredicate = (ComparableScalarSpacePredicate)IOUtils.readObject(in);
        this._highPredicate = (ComparableScalarSpacePredicate)IOUtils.readObject(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeObject(out, this._lowPredicate);
        IOUtils.writeObject(out, this._highPredicate);
    }
}

