/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.predicate.comparison;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.predicate.comparison.ScalarSpacePredicate;
import com.gigaspaces.internal.utils.ObjectUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;

public abstract class ComparableScalarSpacePredicate
extends ScalarSpacePredicate {
    private static final long serialVersionUID = -6819749107818741458L;
    private Comparator _comparator;
    private transient Comparable _preparedExpectedValue;

    protected ComparableScalarSpacePredicate() {
    }

    protected ComparableScalarSpacePredicate(Comparable<?> expectedValue) {
        this(expectedValue, null);
    }

    protected ComparableScalarSpacePredicate(Comparable<?> expectedValue, Comparator<?> comparator) {
        super(expectedValue, null);
        if (expectedValue == null) {
            throw new IllegalArgumentException("Argument 'expectedValue' cannot be null.");
        }
        this._comparator = comparator;
    }

    public Comparator getComparator() {
        return this._comparator;
    }

    @Override
    protected boolean match(Object actual, Object expected) {
        if (actual == null) {
            return false;
        }
        if (this._preparedExpectedValue == null) {
            this._preparedExpectedValue = this.prepare(expected);
        }
        int result = this._comparator == null ? this._preparedExpectedValue.compareTo(actual) : this._comparator.compare(this._preparedExpectedValue, actual);
        return this.compare(result);
    }

    private Comparable<?> prepare(Object expected) {
        return (Comparable)expected;
    }

    protected abstract boolean compare(int var1);

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ComparableScalarSpacePredicate other = (ComparableScalarSpacePredicate)obj;
        if (!ObjectUtils.equals(this.getComparator(), other.getComparator())) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._comparator = (Comparator)IOUtils.readObject(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeObject(out, this._comparator);
    }
}

