/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.predicate.comparison;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ShortList;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.AbstractTypeIntrospector;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.query.ConvertedObjectWrapper;
import com.gigaspaces.internal.query.predicate.ISpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.EqualsSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.GreaterEqualsSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.GreaterSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.InSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.LessEqualsSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.LessSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.NotEqualsSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.NotRegexSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.RegexSpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.ScalarSpacePredicate;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.jdbc.builder.range.FunctionCallDescription;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

@InternalApi
public class ContainsPredicate
extends ScalarSpacePredicate {
    private static final long serialVersionUID = 1L;
    protected String[] _tokens = null;
    protected SpacePropertyInfo[] _propertyInfo = null;
    protected ISpacePredicate _spacePredicate = null;
    protected String _fieldPath = null;
    protected short[] _containsIndexes;
    protected short _templateMatchCode;

    public ContainsPredicate() {
    }

    public ContainsPredicate(Object expectedValue, FunctionCallDescription functionCallDescription, String fieldPath, short templateMatchCode) {
        super(expectedValue, functionCallDescription);
        this._fieldPath = fieldPath;
        this._templateMatchCode = templateMatchCode;
    }

    @Override
    protected boolean match(Object actual, Object expected) {
        if (actual == null) {
            return false;
        }
        if (this._templateMatchCode == 0) {
            return ((Collection)actual).contains(this.getPreparedExpectedValue(actual));
        }
        if (this._templateMatchCode == 1) {
            return !((Collection)actual).contains(this.getPreparedExpectedValue(actual));
        }
        for (Object item : (Collection)actual) {
            if (item == null || !this.executePredicate(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getOperatorName() {
        return "contains";
    }

    @Override
    protected Object getPreparedExpectedValue(Object target) {
        if (this._convertedValueWrapper == null) {
            Collection targetCollection = (Collection)target;
            if (targetCollection == null) {
                return this._expectedValue;
            }
            Object collectionItem = null;
            for (Object item : targetCollection) {
                if (item == null) continue;
                collectionItem = item;
                break;
            }
            if (collectionItem == null) {
                return this._expectedValue;
            }
            this._convertedValueWrapper = ConvertedObjectWrapper.create(this._expectedValue, collectionItem.getClass());
        }
        if (this._convertedValueWrapper == null) {
            return this._expectedValue;
        }
        return this._convertedValueWrapper.getValue();
    }

    @Override
    public boolean execute(Object target) {
        Object value;
        if (this._tokens == null || this._containsIndexes == null || this._propertyInfo == null) {
            this.initialize();
        }
        return (value = ((ServerEntry)target).getPropertyValue(this._tokens[0])) == null ? false : this.performMatching(value, 1, 0);
    }

    protected void initialize() {
        String[] temp = this._fieldPath.split("\\.|\\[\\*\\]", -1);
        ArrayList<String> tokens = new ArrayList<String>();
        ShortList containsIndexes = CollectionsFactory.getInstance().createShortList();
        short tokenIndex = 0;
        for (String token : temp) {
            if (token.length() == 0) {
                containsIndexes.add(tokenIndex);
                continue;
            }
            tokens.add(token);
            tokenIndex = (short)(tokenIndex + 1);
        }
        this._tokens = tokens.toArray(new String[tokens.size()]);
        this._containsIndexes = containsIndexes.toNativeArray();
        this._propertyInfo = new SpacePropertyInfo[this._tokens.length];
    }

    protected boolean performMatching(Object value, int tokenIndex, int currentContainsIndex) {
        while (tokenIndex != this._containsIndexes[currentContainsIndex]) {
            if ((value = AbstractTypeIntrospector.getNestedValue(value, tokenIndex++, this._tokens, this._propertyInfo, this._fieldPath)) != null) continue;
            return false;
        }
        if (value instanceof Object[]) {
            value = Arrays.asList((Object[])value);
        } else if (!(value instanceof Collection)) {
            throw new IllegalArgumentException("[*] can only follow a Collection or Object Array. '" + this._tokens[tokenIndex - 1] + "' is not a collection or array in '" + this._fieldPath + "'");
        }
        if (this._containsIndexes.length == ++currentContainsIndex) {
            return this.matchValue((Collection)value, tokenIndex);
        }
        for (Object item : (Collection)value) {
            if (item == null || !this.performMatching(item, tokenIndex, currentContainsIndex)) continue;
            return true;
        }
        return false;
    }

    private boolean matchValue(Collection<?> collection, int tokenIndex) {
        if (tokenIndex == this._tokens.length) {
            return this.match(collection, this.getExpectedValue());
        }
        return this.matchCollectionItemNestedProperty(collection, tokenIndex);
    }

    private boolean matchCollectionItemNestedProperty(Collection<?> collection, int tokenIndex) {
        block4: for (Object item : collection) {
            for (int i = tokenIndex; i < this._tokens.length && item != null; ++i) {
                item = AbstractTypeIntrospector.getNestedValue(item, i, this._tokens, this._propertyInfo, this._fieldPath);
            }
            switch (this._templateMatchCode) {
                case 6: {
                    if (item != null) continue block4;
                    return true;
                }
                case 7: {
                    if (item == null) continue block4;
                    return true;
                }
            }
            if (item == null || !this.executePredicate(item)) continue;
            return true;
        }
        return false;
    }

    protected boolean executePredicate(Object valueToMatch) {
        if (this._spacePredicate == null) {
            Object convertedTemplateValue = ConvertedObjectWrapper.create(this._expectedValue, valueToMatch.getClass()).getValue();
            this._spacePredicate = this.createSpacePredicate(convertedTemplateValue);
        }
        return this._spacePredicate.execute(valueToMatch);
    }

    private ISpacePredicate createSpacePredicate(Object expectedValue) {
        switch (this._templateMatchCode) {
            case 0: {
                return new EqualsSpacePredicate(expectedValue);
            }
            case 1: {
                return new NotEqualsSpacePredicate(expectedValue);
            }
            case 4: {
                return new LessSpacePredicate(this.castToComparable(expectedValue));
            }
            case 5: {
                return new LessEqualsSpacePredicate(this.castToComparable(expectedValue));
            }
            case 2: {
                return new GreaterSpacePredicate(this.castToComparable(expectedValue));
            }
            case 3: {
                return new GreaterEqualsSpacePredicate(this.castToComparable(expectedValue));
            }
            case 8: {
                return new RegexSpacePredicate(((String)expectedValue).replaceAll("%", ".*").replaceAll("_", "."));
            }
            case 10: {
                return new NotRegexSpacePredicate(((String)expectedValue).replaceAll("%", ".*").replaceAll("_", "."));
            }
            case 11: {
                return new InSpacePredicate((Set)expectedValue);
            }
        }
        throw new IllegalArgumentException("Unsupported contains operator.");
    }

    private Comparable<?> castToComparable(Object value) {
        try {
            return (Comparable)value;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Contains operator requires a Comparable class type.", e);
        }
    }

    protected String getFieldPath() {
        return this._fieldPath;
    }

    protected String[] getTokens() {
        return this._tokens;
    }

    protected short[] getContainsIndexes() {
        return this._containsIndexes;
    }

    protected SpacePropertyInfo[] getPropertyInfo() {
        return this._propertyInfo;
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._fieldPath = IOUtils.readString(in);
        this._templateMatchCode = in.readShort();
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeString(out, this._fieldPath);
        out.writeShort(this._templateMatchCode);
    }
}

