/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.predicate.comparison;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.predicate.AbstractSpacePredicate;
import com.gigaspaces.internal.query.predicate.ISpacePredicate;
import com.gigaspaces.internal.query.predicate.comparison.EqualsSpacePredicate;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;

@InternalApi
public class InSpacePredicate
extends AbstractSpacePredicate {
    private static final long serialVersionUID = 1L;
    private Set _inValues;
    private transient ISpacePredicate[] _operands;

    public InSpacePredicate() {
    }

    public InSpacePredicate(Object ... values) {
        this._inValues = new HashSet();
        for (Object value : values) {
            this._inValues.add(value);
        }
    }

    public InSpacePredicate(Set<?> inValues) {
        this._inValues = inValues;
    }

    public int getNumOfExpectedValues() {
        return this._inValues.size();
    }

    public Set<Object> getExpectedValues() {
        return this._inValues;
    }

    @Override
    public boolean execute(Object target) {
        if (this._operands == null) {
            this.prepareOperands();
        }
        for (ISpacePredicate operand : this._operands) {
            if (!operand.execute(target)) continue;
            return true;
        }
        return false;
    }

    private void prepareOperands() {
        ISpacePredicate[] inOperands = new ISpacePredicate[this._inValues.size()];
        int index = 0;
        for (Object value : this._inValues) {
            inOperands[index++] = new EqualsSpacePredicate(value);
        }
        this._operands = inOperands;
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._inValues = (Set)IOUtils.readObject(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeObject(out, this._inValues);
    }

    public Set<?> getInValues() {
        return this._inValues;
    }
}

