/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.predicate.comparison;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.query.predicate.comparison.ScalarSpacePredicate;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalApi
public class RegexSpacePredicate
extends ScalarSpacePredicate {
    private static final long serialVersionUID = 1L;
    private transient Pattern pattern;

    public RegexSpacePredicate() {
    }

    public RegexSpacePredicate(String expectedValue) {
        super(expectedValue, null);
        if (expectedValue == null) {
            throw new IllegalArgumentException("Argument 'expectedValue' cannot be null.");
        }
        this.init();
    }

    private void init() {
        this.pattern = Pattern.compile((String)this._expectedValue);
    }

    @Override
    protected boolean match(Object actual, Object expected) {
        if (actual == null) {
            return false;
        }
        Matcher m = this.pattern.matcher(actual.toString());
        return m.matches();
    }

    @Override
    protected String getOperatorName() {
        return "REGEX";
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this.init();
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
    }
}

