/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.predicate.comparison;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.predicate.comparison.ScalarSpacePredicate;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.QueryExtensionIndexManagerWrapper;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class RelationPredicate
extends ScalarSpacePredicate {
    private static final long serialVersionUID = 1L;
    private String namespace;
    private String typeName;
    private String path;
    private String op;
    private transient QueryExtensionIndexManagerWrapper _handler;
    private transient CacheManager _cacheManager;

    public RelationPredicate() {
    }

    @Override
    public boolean requiresCacheManagerForExecution() {
        return true;
    }

    @Override
    public void setCacheManagerForExecution(CacheManager cacheManager) {
        this._cacheManager = cacheManager;
    }

    public RelationPredicate(String namespace, String typeName, String path, String op, Object value) {
        super(value, null);
        this.namespace = namespace;
        this.typeName = typeName;
        this.path = path;
        this.op = op;
    }

    @Override
    protected boolean match(Object actual, Object expected) {
        if (actual == null) {
            return false;
        }
        if (this._handler == null) {
            this._handler = this._cacheManager.getQueryExtensionManager(this.namespace);
            if (this._handler == null) {
                throw new IllegalStateException("Unknown namespace [" + this.namespace + "]");
            }
        }
        return this._handler.filter(this.typeName, this.path, this.op, actual, expected);
    }

    @Override
    protected String getOperatorName() {
        return this.namespace + ":" + this.op;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeString(out, this.namespace);
        IOUtils.writeString(out, this.typeName);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
            IOUtils.writeString(out, this.path);
        }
        IOUtils.writeString(out, this.op);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.namespace = IOUtils.readString(in);
        this.typeName = IOUtils.readString(in);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v12_1_0)) {
            this.path = IOUtils.readString(in);
        }
        this.op = IOUtils.readString(in);
    }
}

