/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.predicate.comparison;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.ConvertedObjectWrapper;
import com.gigaspaces.internal.query.predicate.AbstractSpacePredicate;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.j_spaces.jdbc.builder.range.FunctionCallDescription;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class ScalarSpacePredicate
extends AbstractSpacePredicate {
    private static final long serialVersionUID = -2962394684649863195L;
    protected Object _expectedValue;
    protected FunctionCallDescription functionCallDescription;
    protected transient ConvertedObjectWrapper _convertedValueWrapper;

    protected ScalarSpacePredicate() {
    }

    protected ScalarSpacePredicate(Object expectedValue, FunctionCallDescription functionCallDescription) {
        this._expectedValue = expectedValue;
        this.functionCallDescription = functionCallDescription;
    }

    public Object getExpectedValue() {
        return this._expectedValue;
    }

    protected Object getPreparedExpectedValue(Object target) {
        if (target == null) {
            return this._expectedValue;
        }
        if (this._convertedValueWrapper == null) {
            this._convertedValueWrapper = ConvertedObjectWrapper.create(this._expectedValue, target.getClass());
        }
        if (this._convertedValueWrapper == null) {
            return this._expectedValue;
        }
        return this._convertedValueWrapper.getValue();
    }

    @Override
    public boolean execute(Object target) {
        return this.match(target, this.getPreparedExpectedValue(target));
    }

    protected abstract boolean match(Object var1, Object var2);

    public String toString() {
        return this.getOperatorName() + "(" + this.getExpectedValue() + ")";
    }

    protected abstract String getOperatorName();

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScalarSpacePredicate other = (ScalarSpacePredicate)obj;
        if (!ObjectUtils.equals(this.getExpectedValue(), other.getExpectedValue())) {
            return false;
        }
        if (this.functionCallDescription != null) {
            return this.functionCallDescription.equals(other.functionCallDescription);
        }
        return other.functionCallDescription == null;
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._expectedValue = IOUtils.readObject(in);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v11_0_0)) {
            this.functionCallDescription = (FunctionCallDescription)IOUtils.readObject(in);
        }
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeObject(out, this._expectedValue);
        IOUtils.writeObject(out, this.functionCallDescription);
    }
}

