/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.predicate.composite;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.predicate.ISpacePredicate;
import com.gigaspaces.internal.query.predicate.composite.CompositeSpacePredicate;
import com.gigaspaces.internal.utils.ObjectUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class BinaryCompositeSpacePredicate
extends CompositeSpacePredicate {
    private static final long serialVersionUID = 1L;
    private ISpacePredicate _leftOperand;
    private ISpacePredicate _rightOperand;

    protected BinaryCompositeSpacePredicate() {
    }

    protected BinaryCompositeSpacePredicate(ISpacePredicate leftOperand, ISpacePredicate rightOperand) {
        if (leftOperand == null) {
            throw new IllegalArgumentException("Argument 'leftOperand' cannot be null.");
        }
        if (rightOperand == null) {
            throw new IllegalArgumentException("Argument 'rightOperand' cannot be null.");
        }
        this._leftOperand = leftOperand;
        this._rightOperand = rightOperand;
    }

    public ISpacePredicate getLeftOperand() {
        return this._leftOperand;
    }

    public ISpacePredicate getRightOperand() {
        return this._rightOperand;
    }

    @Override
    public boolean execute(Object target) {
        return this.execute(target, this._leftOperand, this._rightOperand);
    }

    protected abstract boolean execute(Object var1, ISpacePredicate var2, ISpacePredicate var3);

    public String toString() {
        return "(" + this._leftOperand + ") " + this.getOperatorName() + " (" + this._rightOperand + ")";
    }

    protected abstract String getOperatorName();

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        BinaryCompositeSpacePredicate other = (BinaryCompositeSpacePredicate)obj;
        if (!ObjectUtils.equals(this.getLeftOperand(), other.getLeftOperand())) {
            return false;
        }
        return ObjectUtils.equals(this.getRightOperand(), other.getRightOperand());
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._leftOperand = (ISpacePredicate)IOUtils.readObject(in);
        this._rightOperand = (ISpacePredicate)IOUtils.readObject(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeObject(out, this._leftOperand);
        IOUtils.writeObject(out, this._rightOperand);
    }
}

