/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.predicate.composite;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.predicate.ISpacePredicate;
import com.gigaspaces.internal.query.predicate.composite.CompositeSpacePredicate;
import com.gigaspaces.internal.utils.CollectionUtils;
import com.j_spaces.core.cache.CacheManager;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public abstract class MultipleCompositeSpacePredicate
extends CompositeSpacePredicate {
    private static final long serialVersionUID = 1L;
    private List<ISpacePredicate> _operandsList;
    private transient ISpacePredicate[] _operandsArray;
    protected transient CacheManager _cacheManager;

    public MultipleCompositeSpacePredicate() {
    }

    public MultipleCompositeSpacePredicate(List<ISpacePredicate> operands) {
        if (operands == null) {
            throw new IllegalArgumentException("Argument 'operands' cannot be null.");
        }
        for (int i = 0; i < operands.size(); ++i) {
            if (operands.get(i) != null) continue;
            throw new IllegalArgumentException("Argument 'operands[" + i + "]' cannot be null.");
        }
        this._operandsList = operands;
    }

    public MultipleCompositeSpacePredicate(ISpacePredicate ... operands) {
        if (operands == null) {
            throw new IllegalArgumentException("Argument 'operands' cannot be null.");
        }
        this._operandsList = new ArrayList<ISpacePredicate>(operands.length);
        for (int i = 0; i < operands.length; ++i) {
            if (operands[i] == null) {
                throw new IllegalArgumentException("Argument 'operands[" + i + "]' cannot be null.");
            }
            this._operandsList.add(operands[i]);
        }
    }

    public int getNumOfOperands() {
        return this._operandsList.size();
    }

    public ISpacePredicate getOperand(int index) {
        return this._operandsList.get(index);
    }

    public void setOperand(int index, ISpacePredicate operand) {
        this._operandsList.set(index, operand);
    }

    public void addOperand(ISpacePredicate operand) {
        if (this._operandsList == null) {
            this._operandsList = new ArrayList<ISpacePredicate>();
        }
        this._operandsList.add(operand);
    }

    @Override
    public boolean execute(Object target) {
        if (this._operandsArray == null) {
            this._operandsArray = MultipleCompositeSpacePredicate.prepare(this._operandsList);
        }
        return this.execute(target, this._operandsArray);
    }

    private static ISpacePredicate[] prepare(List<ISpacePredicate> list) {
        int length = list == null ? 0 : list.size();
        ISpacePredicate[] array = new ISpacePredicate[length];
        for (int i = 0; i < length; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }

    protected abstract boolean execute(Object var1, ISpacePredicate[] var2);

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        MultipleCompositeSpacePredicate other = (MultipleCompositeSpacePredicate)obj;
        return CollectionUtils.equals(this._operandsList, other._operandsList);
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        int length = in.readInt();
        this._operandsList = new ArrayList<ISpacePredicate>(length);
        for (int i = 0; i < length; ++i) {
            this._operandsList.add((ISpacePredicate)IOUtils.readObject(in));
        }
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        int length = this._operandsList == null ? 0 : this._operandsList.size();
        out.writeInt(length);
        for (int i = 0; i < length; ++i) {
            IOUtils.writeObject(out, this._operandsList.get(i));
        }
    }

    @Override
    public boolean requiresCacheManagerForExecution() {
        return true;
    }

    @Override
    public void setCacheManagerForExecution(CacheManager cacheManager) {
        this._cacheManager = cacheManager;
    }
}

