/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.predicate.composite;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.predicate.ISpacePredicate;
import com.gigaspaces.internal.query.predicate.composite.CompositeSpacePredicate;
import com.gigaspaces.internal.utils.ObjectUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class UnaryCompositeSpacePredicate
extends CompositeSpacePredicate {
    private static final long serialVersionUID = 1L;
    private ISpacePredicate _operand;

    protected UnaryCompositeSpacePredicate() {
    }

    protected UnaryCompositeSpacePredicate(ISpacePredicate operand) {
        if (operand == null) {
            throw new IllegalArgumentException("Argument 'operand' cannot be null.");
        }
        this._operand = operand;
    }

    public ISpacePredicate getOperand() {
        return this._operand;
    }

    @Override
    public boolean execute(Object target) {
        return this.execute(target, this._operand);
    }

    protected abstract boolean execute(Object var1, ISpacePredicate var2);

    public String toString() {
        return this.getOperatorName() + "(" + this._operand.toString() + ")";
    }

    protected abstract String getOperatorName();

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        UnaryCompositeSpacePredicate other = (UnaryCompositeSpacePredicate)obj;
        return ObjectUtils.equals(this.getOperand(), other.getOperand());
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._operand = (ISpacePredicate)IOUtils.readObject(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeObject(out, this._operand);
    }
}

