/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.valuegetter;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ShortList;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.AbstractTypeIntrospector;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.query.valuegetter.AbstractSpaceValueGetter;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.server.ServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

@InternalApi
public class SpaceEntryCollectionValuesExtractor
extends AbstractSpaceValueGetter<ServerEntry> {
    private static final long serialVersionUID = 5423684060439741346L;
    private String _path;
    private ValuesExtractorParameters _parameters;

    public SpaceEntryCollectionValuesExtractor() {
    }

    public SpaceEntryCollectionValuesExtractor(String path) {
        this._path = path;
    }

    @Override
    public Object getValue(ServerEntry target) {
        Object value;
        if (this._parameters == null) {
            this._parameters = this.initializeValuesExtractorParameters();
        }
        return (value = target.getPropertyValue(this._parameters.getTokens()[0])) == null ? Collections.EMPTY_LIST : this.extractValues(value, 1, 0, new HashSet<Object>());
    }

    private Collection<Object> extractValues(Object value, int tokenIndex, int currentCollectionIndex, Collection<Object> extractedValues) {
        while (tokenIndex != this._parameters.getCollectionIndexes()[currentCollectionIndex]) {
            if ((value = AbstractTypeIntrospector.getNestedValue(value, tokenIndex++, this._parameters.getTokens(), this._parameters.getPropertiesInfo(), this._path)) != null) continue;
            return extractedValues;
        }
        if (!(value instanceof Collection)) {
            if (value instanceof Object[]) {
                value = Arrays.asList((Object[])value);
            } else {
                throw new IllegalArgumentException("value type [" + value.getClass().getName() + "] is not supported - expected Collection<?> or Object[].");
            }
        }
        if (this._parameters.getCollectionIndexes().length == ++currentCollectionIndex) {
            if (this._parameters.getCollectionIndexes().length == 1 && tokenIndex == this._parameters.getTokens().length) {
                return (Collection)value;
            }
            if (tokenIndex == this._parameters.getTokens().length) {
                extractedValues.addAll((Collection)value);
                return extractedValues;
            }
            Iterator iterator = ((Collection)value).iterator();
            while (iterator.hasNext()) {
                Object item;
                Object extractedValue = item = iterator.next();
                for (int i = tokenIndex; extractedValue != null && i < this._parameters.getTokens().length; ++i) {
                    extractedValue = AbstractTypeIntrospector.getNestedValue(extractedValue, i, this._parameters.getTokens(), this._parameters.getPropertiesInfo(), this._path);
                }
                if (extractedValue == null) continue;
                extractedValues.add(extractedValue);
            }
        } else {
            for (Object item : (Collection)value) {
                if (item == null) continue;
                this.extractValues(item, tokenIndex, currentCollectionIndex, extractedValues);
            }
        }
        return extractedValues;
    }

    private ValuesExtractorParameters initializeValuesExtractorParameters() {
        String[] temp = this._path.split("\\.|\\[\\*\\]", -1);
        ArrayList<String> tokens = new ArrayList<String>();
        ShortList collectionIndexes = CollectionsFactory.getInstance().createShortList();
        short tokenIndex = 0;
        for (String token : temp) {
            if (token.length() == 0) {
                collectionIndexes.add(tokenIndex);
                continue;
            }
            tokens.add(token);
            tokenIndex = (short)(tokenIndex + 1);
        }
        return new ValuesExtractorParameters(tokens, collectionIndexes.toNativeArray());
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        SpaceEntryCollectionValuesExtractor other = (SpaceEntryCollectionValuesExtractor)obj;
        return ObjectUtils.equals(this._path, other._path);
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._path = IOUtils.readString(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeString(out, this._path);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalImpl(in);
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        this.writeExternalImpl(out);
    }

    private static class ValuesExtractorParameters {
        private final String[] _tokens;
        private final short[] _collectionIndexes;
        private final SpacePropertyInfo[] _propertiesInfo;

        public ValuesExtractorParameters(ArrayList<String> tokens, short[] collectionIndexes) {
            String[] tokensArray = new String[tokens.size()];
            this._tokens = tokens.toArray(tokensArray);
            this._collectionIndexes = collectionIndexes;
            this._propertiesInfo = new SpacePropertyInfo[tokens.size()];
        }

        public String[] getTokens() {
            return this._tokens;
        }

        public short[] getCollectionIndexes() {
            return this._collectionIndexes;
        }

        public SpacePropertyInfo[] getPropertiesInfo() {
            return this._propertiesInfo;
        }
    }
}

