/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.valuegetter;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.valuegetter.AbstractSpaceValueGetter;
import com.gigaspaces.metadata.index.ISpaceCompoundIndexSegment;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.CompoundIndexValueHolder;
import com.j_spaces.core.cache.SimpleCompoundIndexValueHolder;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

@InternalApi
public class SpaceEntryCompoundIndexGetter
extends AbstractSpaceValueGetter<ServerEntry> {
    private static final long serialVersionUID = -9025377890997556363L;
    private ISpaceCompoundIndexSegment[] _segments;

    public SpaceEntryCompoundIndexGetter() {
    }

    public ISpaceCompoundIndexSegment[] getSegments() {
        return this._segments;
    }

    public SpaceEntryCompoundIndexGetter(ISpaceCompoundIndexSegment[] segments) {
        this._segments = segments;
    }

    @Override
    public Object getValue(ServerEntry target) {
        if (this.anyNullSegment(target)) {
            return null;
        }
        return this._segments.length == 2 ? new SimpleCompoundIndexValueHolder(this._segments, target) : new CompoundIndexValueHolder(this._segments, target);
    }

    public boolean anyNullSegment(ServerEntry entry) {
        if (this._segments.length == 2) {
            return this._segments[0].getSegmentValue(entry) == null || this._segments[1].getSegmentValue(entry) == null;
        }
        for (ISpaceCompoundIndexSegment segment : this._segments) {
            if (segment.getSegmentValue(entry) != null) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        SpaceEntryCompoundIndexGetter other = (SpaceEntryCompoundIndexGetter)obj;
        return Arrays.deepEquals(this._segments, other._segments);
    }

    public int hashCode() {
        return this._segments[0].hashCode();
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._segments = (ISpaceCompoundIndexSegment[])IOUtils.readObject(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeObject(out, this._segments);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalImpl(in);
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        this.writeExternalImpl(out);
    }
}

