/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.valuegetter;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.AbstractTypeIntrospector;
import com.gigaspaces.internal.query.valuegetter.AbstractSpaceValueGetter;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.server.ServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class SpaceEntryPathGetter
extends AbstractSpaceValueGetter<ServerEntry> {
    private static final long serialVersionUID = -9025377890997556363L;
    private String _path;
    private transient String[] _tokens;

    public SpaceEntryPathGetter() {
    }

    public SpaceEntryPathGetter(String path) {
        this._path = path;
    }

    @Override
    public Object getValue(ServerEntry target) {
        if (this._tokens == null) {
            this.prepare(target.getSpaceTypeDescriptor());
        }
        Object root = target.getPropertyValue(this._tokens[0]);
        return AbstractTypeIntrospector.getPathValue(root, this._tokens, this._path);
    }

    public String getPath() {
        return this._path;
    }

    private void prepare(SpaceTypeDescriptor typeDescriptor) {
        this._tokens = this._path.split("\\.");
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        SpaceEntryPathGetter other = (SpaceEntryPathGetter)obj;
        return ObjectUtils.equals(this._path, other._path);
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._path = IOUtils.readString(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        IOUtils.writeString(out, this._path);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalImpl(in);
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        this.writeExternalImpl(out);
    }
}

