/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.query.valuegetter;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.query.valuegetter.AbstractSpaceValueGetter;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.server.ServerEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class SpaceEntryPropertyGetter
extends AbstractSpaceValueGetter<ServerEntry> {
    private static final long serialVersionUID = -2780950582604448258L;
    private int _propertyIndex;
    private String _propertyName;

    public SpaceEntryPropertyGetter() {
    }

    public SpaceEntryPropertyGetter(int index) {
        this._propertyIndex = index;
    }

    public SpaceEntryPropertyGetter(String name) {
        this._propertyName = name;
        this._propertyIndex = -1;
    }

    @Override
    public Object getValue(ServerEntry target) {
        if (this._propertyIndex == -1) {
            this._propertyIndex = this.prepare(target.getSpaceTypeDescriptor());
        }
        if (this._propertyIndex == -1) {
            return target.getPropertyValue(this._propertyName);
        }
        return target.getFixedPropertyValue(this._propertyIndex);
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    private int prepare(SpaceTypeDescriptor typeDescriptor) {
        return typeDescriptor.getFixedPropertyPosition(this._propertyName);
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        SpaceEntryPropertyGetter other = (SpaceEntryPropertyGetter)obj;
        if (this._propertyIndex != other._propertyIndex) {
            return false;
        }
        return ObjectUtils.equals(this._propertyName, other._propertyName);
    }

    @Override
    protected void readExternalImpl(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternalImpl(in);
        this._propertyIndex = in.readInt();
        this._propertyName = IOUtils.readString(in);
    }

    @Override
    protected void writeExternalImpl(ObjectOutput out) throws IOException {
        super.writeExternalImpl(out);
        out.writeInt(this._propertyIndex);
        IOUtils.writeString(out, this._propertyName);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternalImpl(in);
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        this.writeExternalImpl(out);
    }
}

