/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.quiesce;

import com.gigaspaces.admin.quiesce.InstancesQuiesceState;
import com.gigaspaces.admin.quiesce.QuiesceState;
import com.gigaspaces.admin.quiesce.QuiesceToken;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class InternalQuiesceDetails
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private QuiesceState status;
    private QuiesceToken token;
    private String description;
    private InstancesQuiesceState instancesState;

    public InternalQuiesceDetails() {
    }

    public InternalQuiesceDetails(QuiesceState status, QuiesceToken token, String description) {
        this.status = status;
        this.token = token;
        this.description = description;
    }

    public QuiesceState getStatus() {
        return this.status;
    }

    public QuiesceToken getToken() {
        return this.token;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalQuiesceDetails that = (InternalQuiesceDetails)o;
        return this.token.equals(that.token);
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public String toString() {
        return "QuiesceDetails{status=" + (Object)((Object)this.status) + ", token=" + this.token + ", description='" + this.description + '\'' + '}';
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.status.getCode());
        IOUtils.writeObject(out, this.token);
        IOUtils.writeString(out, this.description);
        IOUtils.writeObject(out, this.instancesState);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int quiesceStateCode = in.readInt();
        this.status = QuiesceState.traslateCodeToState(quiesceStateCode);
        this.token = (QuiesceToken)IOUtils.readObject(in);
        this.description = IOUtils.readString(in);
        this.instancesState = (InstancesQuiesceState)IOUtils.readObject(in);
    }

    public InstancesQuiesceState getInstancesState() {
        return this.instancesState;
    }

    public void setInstancesState(InstancesQuiesceState instancesState) {
        this.instancesState = instancesState;
    }

    public String getAction() {
        switch (this.status.getCode()) {
            case 0: {
                return "Quiesce";
            }
            case 1: {
                return "Unquiesce";
            }
        }
        return "Unquiesce/Quiesce";
    }
}

