/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.quiesce;

import com.gigaspaces.admin.quiesce.QuiesceToken;
import com.gigaspaces.admin.quiesce.QuiesceTokenFactory;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class InternalQuiesceRequest
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String description;
    private QuiesceToken token;

    public InternalQuiesceRequest() {
    }

    public InternalQuiesceRequest(String description) {
        this.description = description;
        this.token = QuiesceTokenFactory.createUUIDToken();
    }

    public String getDescription() {
        return this.description;
    }

    public QuiesceToken getToken() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalQuiesceRequest that = (InternalQuiesceRequest)o;
        return this.token.equals(that.token);
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this.token);
        IOUtils.writeString(out, this.description);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.token = (QuiesceToken)IOUtils.readObject(in);
        this.description = IOUtils.readString(in);
    }
}

