/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import java.lang.reflect.Method;

@InternalApi
public class MethodHolder {
    private final Method _method;
    private final String _methodDescriptor;

    public MethodHolder(Method method) {
        this._method = method;
        this._methodDescriptor = ReflectionUtil.getMethodDescriptor(method);
    }

    public Method getMethod() {
        return this._method;
    }

    public String getMethodDescriptor() {
        return this._methodDescriptor;
    }

    public String getName() {
        return this._method.getName();
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this._methodDescriptor.hashCode();
    }

    public boolean equals(Object other) {
        MethodHolder otherMethod = (MethodHolder)other;
        return this.getName().equals(otherMethod.getName()) && this._methodDescriptor.equals(otherMethod.getMethodDescriptor());
    }
}

