/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.reflection.IConstructor;
import com.gigaspaces.internal.reflection.IDynamicProxy;
import com.gigaspaces.internal.reflection.IField;
import com.gigaspaces.internal.reflection.IGetterMethod;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.IParamsConstructor;
import com.gigaspaces.internal.reflection.IProperties;
import com.gigaspaces.internal.reflection.IReflectionFactory;
import com.gigaspaces.internal.reflection.ISetterMethod;
import com.gigaspaces.internal.reflection.ProxyInvocationHandler;
import com.gigaspaces.internal.reflection.fast.ASMReflectionFactory;
import com.gigaspaces.internal.reflection.standard.StandardReflectionFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;

@InternalApi
public class ReflectionUtil {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.reflection");
    private static final Class<?>[] noArg = new Class[0];
    private static final int IGNORE_MODES = 152;
    private static final IReflectionFactory _reflectionFactory = ReflectionUtil.initialize();

    private static IReflectionFactory initialize() {
        Class<ASMReflectionFactory> factoryClass = ASMReflectionFactory.class;
        IReflectionFactory reflectionFactory = (IReflectionFactory)ReflectionUtil.createInstanceWithOptionalDependencies(factoryClass);
        if (reflectionFactory == null) {
            _logger.log(Level.WARNING, "Failed to create reflection factory [" + factoryClass.getName() + "], falling back to standard reflection instead");
            reflectionFactory = new StandardReflectionFactory();
        }
        return reflectionFactory;
    }

    public static Object createInstanceWithOptionalDependencies(Class<?> factoryClass) {
        try {
            return factoryClass.newInstance();
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to create an instance of " + factoryClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to create an instance of " + factoryClass.getName(), e);
        }
    }

    public static Object createProxy(ClassLoader loader, Class<?>[] interfaces, ProxyInvocationHandler handler, boolean allowCache) {
        return _reflectionFactory.getProxy(loader, interfaces, handler, allowCache);
    }

    public static <T> IConstructor<T> createCtor(Constructor<T> ctor) {
        return _reflectionFactory.getConstructor(ctor);
    }

    public static <T> IParamsConstructor<T> createParamsCtor(Constructor<T> ctor) {
        return _reflectionFactory.getParamsConstructor(ctor);
    }

    public static <T> IMethod<T> createMethod(Method method) {
        return _reflectionFactory.getMethod(method);
    }

    public static <T> IMethod<T> createMethod(ClassLoader classLoader, Method method) {
        return _reflectionFactory.getMethod(classLoader, method);
    }

    public static <T> IMethod<T>[] createMethods(Method[] methods) {
        return _reflectionFactory.getMethods(methods);
    }

    public static <T> IMethod<T>[] createMethods(ClassLoader classLoader, Method[] methods) {
        return _reflectionFactory.getMethods(classLoader, methods);
    }

    public static <T> IGetterMethod<T> createGetterMethod(Method method) {
        return _reflectionFactory.getGetterMethod(method);
    }

    public static <T> IGetterMethod<T> createGetterMethod(ClassLoader classLoader, Method method) {
        return _reflectionFactory.getGetterMethod(classLoader, method);
    }

    public static <T> ISetterMethod<T> createSetterMethod(Method method) {
        return _reflectionFactory.getSetterMethod(method);
    }

    public static <T> ISetterMethod<T> createSetterMethod(ClassLoader classLoader, Method method) {
        return _reflectionFactory.getSetterMethod(classLoader, method);
    }

    public static <T, F> IField<T, F> createField(Field field) {
        return _reflectionFactory.getField(field);
    }

    public static <T> IProperties<T> createFieldProperties(Class<T> declaringClass, Field[] fields) {
        return _reflectionFactory.getFieldProperties(declaringClass, fields);
    }

    public static <T> String[] getConstructorParametersNames(Constructor<T> ctor) {
        return _reflectionFactory.getConstructorParametersNames(ctor);
    }

    public static <T> IProperties<T> createProperties(SpaceTypeInfo typeInfo) {
        return _reflectionFactory.getProperties(typeInfo);
    }

    private static void sortClassFields(List<IField> fields) {
        class FieldsComparator<T>
        implements Comparator<IField<T, ?>> {
            FieldsComparator() {
            }

            @Override
            public int compare(IField<T, ?> f1, IField<T, ?> f2) {
                return f1.getName().compareTo(f2.getName());
            }
        }
        Collections.sort(fields, new FieldsComparator());
    }

    public static List<IField> getCanonicalSortedFields(Class claz) {
        if (claz == Object.class) {
            return new ArrayList<IField>();
        }
        List<IField> fieldsOfSuperClass = ReflectionUtil.getCanonicalSortedFields(claz.getSuperclass());
        IField<T, F>[] fields = _reflectionFactory.getFields(claz);
        HashSet<IField> fieldsOfSuperClassSet = new HashSet<IField>();
        fieldsOfSuperClassSet.addAll(fieldsOfSuperClass);
        ArrayList<IField> fieldsOfClaz = new ArrayList<IField>();
        for (IField field : fields) {
            if (!ReflectionUtil.isUsableField(field) || fieldsOfSuperClassSet.contains(field)) continue;
            fieldsOfClaz.add(field);
        }
        ReflectionUtil.sortClassFields(fieldsOfClaz);
        ArrayList<IField> result = new ArrayList<IField>();
        result.addAll(fieldsOfSuperClass);
        result.addAll(fieldsOfClaz);
        return result;
    }

    public static boolean isPublic(Class<?> type) {
        return Modifier.isPublic(type.getModifiers());
    }

    public static void assertIsPublic(Class<?> type) {
        if (!ReflectionUtil.isPublic(type)) {
            throw new IllegalArgumentException("Class '" + type.getName() + "' is not public.");
        }
    }

    public static <T> Constructor<T> getDefaultConstructor(Class<T> type) {
        try {
            return type.getDeclaredConstructor(noArg);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Failed to get default constructor for class '" + type.getName() + "'.", e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Failed to get default constructor for class '" + type.getName() + "'.", e);
        }
    }

    public static void assertHasDefaultConstructor(Class<?> type) {
        ReflectionUtil.getDefaultConstructor(type);
    }

    public static boolean isPojo(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Object[]) {
            if (object instanceof Entry[]) {
                return false;
            }
            if (Array.getLength(object) == 0) {
                return false;
            }
            Object value = Array.get(object, 0);
            if (value == null || value instanceof Entry) {
                return false;
            }
        } else if (object instanceof Entry) {
            return false;
        }
        return true;
    }

    public static boolean isProxyClass(Class<?> clz) {
        return IDynamicProxy.class.isAssignableFrom(clz) || Proxy.isProxyClass(clz);
    }

    public static Object getInvocationHandler(Object obj) {
        if (obj instanceof IDynamicProxy) {
            return ((IDynamicProxy)obj).getInvocatioHandler();
        }
        if (Proxy.isProxyClass(obj.getClass())) {
            return Proxy.getInvocationHandler(obj);
        }
        throw new IllegalArgumentException("not a proxy instance");
    }

    private static boolean isUsableField(IField<?, ?> field) {
        if ((field.getModifiers() & 0x98) != 0) {
            return false;
        }
        if (field.getType().isPrimitive()) {
            throw new IllegalArgumentException("Primitive fields not allowed in an Entry. Cause primitive field: [ " + field + "]");
        }
        return true;
    }

    public static Set<Class> getAllInterfacesForClassAsSet(Class clazz) {
        LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
        if (!clazz.isInterface()) {
            if (clazz.getSuperclass() != null) {
                interfaces.addAll(ReflectionUtil.getAllInterfacesForClassAsSet(clazz.getSuperclass()));
            }
        } else {
            interfaces.add(clazz);
        }
        Class<?>[] ifcs = clazz.getInterfaces();
        for (int i = 0; i < ifcs.length; ++i) {
            interfaces.addAll(ReflectionUtil.getAllInterfacesForClassAsSet(ifcs[i]));
        }
        return interfaces;
    }

    public static String getInternalName(Class c) {
        return c.getName().replace('.', '/');
    }

    public static String getDescriptor(Class c) {
        StringBuffer buf = new StringBuffer();
        ReflectionUtil.getDescriptor(buf, c);
        return buf.toString();
    }

    private static void getDescriptor(StringBuffer buf, Class c) {
        Class<?> d = c;
        while (true) {
            if (d.isPrimitive()) {
                int car = d == Integer.TYPE ? 73 : (d == Void.TYPE ? 86 : (d == Boolean.TYPE ? 90 : (d == Byte.TYPE ? 66 : (d == Character.TYPE ? 67 : (d == Short.TYPE ? 83 : (d == Double.TYPE ? 68 : (d == Float.TYPE ? 70 : 74)))))));
                buf.append((char)car);
                return;
            }
            if (!d.isArray()) break;
            buf.append('[');
            d = d.getComponentType();
        }
        buf.append('L');
        String name = d.getName();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char car = name.charAt(i);
            buf.append(car == '.' ? (char)'/' : (char)car);
        }
        buf.append(';');
    }

    public static ClassLoader getClassTargetLoader(Class memberClass) {
        ClassLoader memberClassLoader = memberClass.getClassLoader();
        if (ReflectionUtil.class.getClassLoader().equals(memberClassLoader)) {
            return memberClassLoader;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (!ReflectionUtil.isValidClassLoader(classLoader, memberClassLoader)) {
            classLoader = memberClassLoader;
        }
        return classLoader == null ? ReflectionUtil.class.getClassLoader() : classLoader;
    }

    private static boolean isValidClassLoader(ClassLoader checkClassLoader, ClassLoader memberClassLoader) {
        boolean valid = false;
        if (memberClassLoader == null) {
            valid = true;
        } else {
            for (ClassLoader classLoader = checkClassLoader; classLoader != null; classLoader = classLoader.getParent()) {
                if (classLoader != memberClassLoader) continue;
                valid = true;
            }
        }
        if (!valid) {
            return false;
        }
        ClassLoader thisClassLoader = ReflectionUtil.class.getClassLoader();
        for (ClassLoader classLoader = checkClassLoader; classLoader != null; classLoader = classLoader.getParent()) {
            if (classLoader != thisClassLoader) continue;
            return true;
        }
        return false;
    }

    public static String getMethodDescriptor(Method m) {
        Class<?>[] parameters = m.getParameterTypes();
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        for (int i = 0; i < parameters.length; ++i) {
            ReflectionUtil.getDescriptor(buf, parameters[i]);
        }
        buf.append(')');
        ReflectionUtil.getDescriptor(buf, m.getReturnType());
        return buf.toString();
    }
}

