/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.fast;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.reflection.IConstructor;
import com.gigaspaces.internal.reflection.IParamsConstructor;
import com.gigaspaces.internal.reflection.fast.ASMFactoryUtils;
import com.gigaspaces.internal.reflection.fast.MethodGenerator;
import java.lang.reflect.Constructor;
import org.objectweb.gs.asm.ClassVisitor;
import org.objectweb.gs.asm.ClassWriter;
import org.objectweb.gs.asm.Type;

@InternalApi
public class ASMConstructorFactory {
    private static final String OBJECT_INTERNAL_NAME = Type.getInternalName(Object.class);
    private static final String CLASS_POSTFIX_NAME = "GigaspacesCtor";
    private static final String CLASS_PARAMS_POSTFIX_NAME = "GigaspacesParamsCtor";
    private static final String[] ICONSTRUCTOR_INTERNAL_NAME = new String[]{Type.getInternalName(IConstructor.class)};
    private static final String[] IPARAMSCONSTRUCTOR_INTERNAL_NAME = new String[]{Type.getInternalName(IParamsConstructor.class)};

    public static synchronized IConstructor getConstructor(Constructor originalCtor) throws NoSuchMethodException {
        return (IConstructor)ASMConstructorFactory.getConstructorImpl(originalCtor, false);
    }

    public static synchronized IParamsConstructor getParamsConstructor(Constructor originalCtor) throws NoSuchMethodException {
        return (IParamsConstructor)ASMConstructorFactory.getConstructorImpl(originalCtor, true);
    }

    private static synchronized Object getConstructorImpl(Constructor originalCtor, boolean params) throws NoSuchMethodException {
        int ctorIndex;
        Class declaringClass = originalCtor.getDeclaringClass();
        String ownerClassName = declaringClass.getName();
        Constructor<?>[] declaredCtors = declaringClass.getDeclaredConstructors();
        for (ctorIndex = 0; ctorIndex < declaredCtors.length && !declaredCtors[ctorIndex].equals(originalCtor); ++ctorIndex) {
        }
        String classPostfixName = params ? CLASS_PARAMS_POSTFIX_NAME : CLASS_POSTFIX_NAME;
        String className = ASMFactoryUtils.getCreateClassNamePrefix(ownerClassName) + classPostfixName + ctorIndex;
        try {
            ClassLoader targetClassLoader = ASMFactoryUtils.getClassTargetLoader(declaringClass);
            String classInternalName = className.replace('.', '/');
            String[] interfaces = params ? IPARAMSCONSTRUCTOR_INTERNAL_NAME : ICONSTRUCTOR_INTERNAL_NAME;
            ClassWriter cw = new ClassWriter(1);
            cw.visit(49, 33, classInternalName, null, OBJECT_INTERNAL_NAME, interfaces);
            ASMConstructorFactory.createConstructor(cw);
            if (params) {
                ASMConstructorFactory.createNewInstanceVarArgsMethod(cw, declaringClass, originalCtor);
            } else {
                ASMConstructorFactory.createNewInstanceMethod(cw, declaringClass);
            }
            cw.visitEnd();
            byte[] b = cw.toByteArray();
            Class definedClass = ASMFactoryUtils.defineClass(targetClassLoader, className, b);
            return definedClass.newInstance();
        }
        catch (Exception e) {
            NoSuchMethodException ex = new NoSuchMethodException("Failed generating ASM constructor wrapper: " + e.toString());
            ex.initCause(e);
            throw ex;
        }
    }

    private static void createConstructor(ClassWriter cw) {
        MethodGenerator mv = MethodGenerator.newConstructor((ClassVisitor)cw, "()V");
        mv.start();
        mv.loadThis();
        mv.invokeConstructor("java/lang/Object", "()V");
        mv.returnVoid();
    }

    private static void createNewInstanceMethod(ClassWriter cw, Class clz) {
        MethodGenerator mv = MethodGenerator.newMethod((ClassVisitor)cw, "newInstance", "()Ljava/lang/Object;");
        mv.start();
        mv.newInstance(Type.getInternalName((Class)clz));
        mv.dup();
        mv.invokeConstructor(Type.getInternalName((Class)clz), "()V");
        mv.returnObject();
    }

    private static void createNewInstanceVarArgsMethod(ClassWriter cw, Class clz, Constructor constructor) {
        MethodGenerator mv = MethodGenerator.newMethod((ClassVisitor)cw, "newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;");
        mv.start();
        mv.newInstance(Type.getInternalName((Class)clz));
        mv.dup();
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            mv.loadArrayItemFromVariable(1, i);
            mv.unboxIfNeeded(parameterTypes[i]);
        }
        mv.invokeConstructor(Type.getInternalName((Class)clz), Type.getConstructorDescriptor((Constructor)constructor));
        mv.returnObject();
    }
}

