/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.fast;

import com.gigaspaces.internal.reflection.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ASMFactoryUtils {
    private static final Method DEFINE_METHOD;
    private static final Method FIND_LODADED;

    public static Class defineClass(ClassLoader loader, String name, byte[] b) throws Exception {
        if (FIND_LODADED != null) {
            try {
                Class loaded = (Class)FIND_LODADED.invoke((Object)loader, name);
                if (loaded != null) {
                    return loaded;
                }
            }
            catch (InvocationTargetException loaded) {
                // empty catch block
            }
        }
        try {
            return (Class)DEFINE_METHOD.invoke((Object)loader, name, b, 0, b.length);
        }
        catch (InvocationTargetException e) {
            return loader.loadClass(name);
        }
    }

    public static ClassLoader getClassTargetLoader(Class memberClass) {
        return ReflectionUtil.getClassTargetLoader(memberClass);
    }

    public static String getCreateClassNamePrefix(String className) {
        return className.startsWith("java.") ? "com.gigaspaces." + className : className;
    }

    static {
        Method defineMethod = null;
        Method findLoaded = null;
        try {
            defineMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineMethod.setAccessible(true);
            findLoaded = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            findLoaded.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFINE_METHOD = defineMethod;
        FIND_LODADED = findLoaded;
    }
}

