/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.fast;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.reflection.IField;
import com.gigaspaces.internal.reflection.fast.ASMFactoryUtils;
import com.gigaspaces.internal.reflection.fast.MethodGenerator;
import com.gigaspaces.internal.reflection.standard.StandardField;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.objectweb.gs.asm.ClassVisitor;
import org.objectweb.gs.asm.ClassWriter;
import org.objectweb.gs.asm.Type;

@InternalApi
public class ASMFieldFactory {
    private static final String CLASS_POSTFIX_NAME = "GigaspacesField";
    private static final String STANDARD_FIELD_INTERNAL_NAME = Type.getInternalName(StandardField.class);

    public static IField getField(Field refField) throws NoSuchFieldException {
        int fieldIndex;
        Class<?> declaringClass = refField.getDeclaringClass();
        String ownerClassName = declaringClass.getName();
        Field[] declaredFields = declaringClass.getDeclaredFields();
        for (fieldIndex = 0; fieldIndex < declaredFields.length && !declaredFields[fieldIndex].equals(refField); ++fieldIndex) {
        }
        String className = ASMFactoryUtils.getCreateClassNamePrefix(ownerClassName) + CLASS_POSTFIX_NAME + fieldIndex;
        try {
            ClassLoader targetClassLoader = ASMFactoryUtils.getClassTargetLoader(declaringClass);
            String classInternalName = className.replace('.', '/');
            ClassWriter cw = new ClassWriter(1);
            cw.visit(49, 33, classInternalName, null, STANDARD_FIELD_INTERNAL_NAME, null);
            ASMFieldFactory.createConstructor((ClassVisitor)cw);
            ASMFieldFactory.createGetMethod((ClassVisitor)cw, declaringClass, refField);
            ASMFieldFactory.createSetMethod((ClassVisitor)cw, declaringClass, refField);
            cw.visitEnd();
            byte[] b = cw.toByteArray();
            Class definedClass = ASMFactoryUtils.defineClass(targetClassLoader, className, b);
            Constructor ctor = definedClass.getConstructor(Field.class);
            return (IField)ctor.newInstance(refField);
        }
        catch (Exception e) {
            NoSuchFieldException err = new NoSuchFieldException("Failed generating ASM field wrapper: " + e.toString());
            err.initCause(e);
            throw err;
        }
    }

    private static void createConstructor(ClassVisitor cw) {
        MethodGenerator mv = MethodGenerator.newConstructor(cw, "(Ljava/lang/reflect/Field;)V");
        mv.start();
        mv.loadThis();
        mv.loadVariable(1);
        mv.invokeConstructor(STANDARD_FIELD_INTERNAL_NAME, "(Ljava/lang/reflect/Field;)V");
        mv.returnVoid();
    }

    private static void createGetMethod(ClassVisitor cw, Class entryClass, Field field) {
        MethodGenerator mv = MethodGenerator.newMethod(cw, "get", "(Ljava/lang/Object;)Ljava/lang/Object;", new String[]{"java/lang/IllegalArgumentException", "java/lang/IllegalAccessException"});
        mv.start();
        mv.castVariable(1, Type.getInternalName((Class)entryClass));
        mv.loadField(entryClass, field);
        mv.boxIfNeeded(field.getType());
        mv.returnObject();
    }

    private static void createSetMethod(ClassVisitor cw, Class entryClass, Field field) {
        MethodGenerator mv = MethodGenerator.newMethod(cw, "set", "(Ljava/lang/Object;Ljava/lang/Object;)V", new String[]{"java/lang/IllegalArgumentException", "java/lang/IllegalAccessException"});
        mv.start();
        mv.castVariable(1, Type.getInternalName((Class)entryClass));
        mv.loadVariable(2);
        mv.unboxIfNeeded(field.getType());
        mv.storeField(entryClass, field);
        mv.returnVoid();
    }
}

