/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.fast;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.reflection.IProperties;
import com.gigaspaces.internal.reflection.fast.ASMFactoryUtils;
import com.gigaspaces.internal.reflection.fast.MethodGenerator;
import java.lang.reflect.Field;
import org.objectweb.gs.asm.ClassVisitor;
import org.objectweb.gs.asm.ClassWriter;
import org.objectweb.gs.asm.Type;

@InternalApi
public class ASMFieldPropertiesFactory {
    private static final String CLASS_PROPERTIES_POSTFIX_NAME = "__GigaspacesFieldProperties__";

    public static <T> IProperties<T> getProperties(Class declaringClass, Field[] fields) throws NoSuchFieldException {
        String ownerClassName = declaringClass.getName();
        String className = ASMFactoryUtils.getCreateClassNamePrefix(ownerClassName) + CLASS_PROPERTIES_POSTFIX_NAME;
        try {
            ClassLoader targetClassLoader = ASMFactoryUtils.getClassTargetLoader(declaringClass);
            String classInternalName = className.replace('.', '/');
            ClassWriter cw = new ClassWriter(1);
            cw.visit(49, 1, classInternalName, null, "java/lang/Object", new String[]{IProperties.Helper.INTERNAL_NAME});
            ASMFieldPropertiesFactory.createCtor(cw);
            String ownerClassNameInternalName = ownerClassName.replace('.', '/');
            ASMFieldPropertiesFactory.createGetter(cw, ownerClassNameInternalName, fields);
            ASMFieldPropertiesFactory.createSetter(cw, ownerClassNameInternalName, fields);
            cw.visitEnd();
            byte[] b = cw.toByteArray();
            Class definedClass = ASMFactoryUtils.defineClass(targetClassLoader, className, b);
            return (IProperties)definedClass.newInstance();
        }
        catch (Exception e) {
            NoSuchFieldException ex = new NoSuchFieldException("Can't create helper to: " + ownerClassName);
            ex.initCause(e);
            throw ex;
        }
    }

    private static void createCtor(ClassWriter cw) {
        MethodGenerator mv = MethodGenerator.newConstructor((ClassVisitor)cw, "()V");
        mv.start();
        mv.loadThis();
        mv.invokeConstructor("java/lang/Object", "()V");
        mv.returnVoid();
    }

    private static void createGetter(ClassWriter cw, String internalClassName, Field[] fields) {
        MethodGenerator mv = MethodGenerator.newMethod((ClassVisitor)cw, IProperties.Helper.getterName(), IProperties.Helper.getterDesc(), IProperties.Helper.exceptions());
        mv.castVariableIntoVariable(1, internalClassName, 2);
        mv.newArray("java/lang/Object", fields.length);
        mv.storeVariable(3);
        for (int i = 0; i < fields.length; ++i) {
            mv.loadVariable(3);
            mv.loadConstant(i);
            mv.loadVariable(2);
            Type type = Type.getType(fields[i].getType());
            mv.loadField(internalClassName, fields[i].getName(), type.getDescriptor());
            mv.storeArrayItem();
        }
        mv.loadVariable(3);
        mv.returnObject();
    }

    private static void createSetter(ClassWriter cw, String internalClassName, Field[] fields) {
        MethodGenerator mv = MethodGenerator.newMethod((ClassVisitor)cw, IProperties.Helper.setterName(), IProperties.Helper.setterDesc());
        mv.castVariableIntoVariable(1, internalClassName, 3);
        for (int i = 0; i < fields.length; ++i) {
            mv.loadVariable(3);
            mv.loadArrayItemFromVariable(2, i);
            Type type = Type.getType(fields[i].getType());
            mv.checkCast(type.getInternalName());
            mv.storeField(internalClassName, fields[i].getName(), type.getDescriptor());
        }
        mv.returnVoid();
    }
}

