/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.fast;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.reflection.IGetterMethod;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.IProcedure;
import com.gigaspaces.internal.reflection.ISetterMethod;
import com.gigaspaces.internal.reflection.fast.ASMFactoryUtils;
import com.gigaspaces.internal.reflection.fast.AbstractGetterMethod;
import com.gigaspaces.internal.reflection.fast.AbstractMethod;
import com.gigaspaces.internal.reflection.fast.AbstractSetterMethod;
import com.gigaspaces.internal.reflection.fast.MethodGenerator;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.objectweb.gs.asm.ClassVisitor;
import org.objectweb.gs.asm.ClassWriter;
import org.objectweb.gs.asm.Type;

@InternalApi
public class ASMMethodFactory {
    private static final String CLASS_POSTFIX_NAME = "GigaspacesMethod";

    private static <T extends IProcedure> T getProcedure(ClassLoader classLoader, Method refMethod, String name, String desc, String superClass, boolean argsParams, boolean returnValue) throws SecurityException, NoSuchMethodException {
        int methodIndex;
        Class<?> methodClass = refMethod.getDeclaringClass();
        Method[] declaredMethods = methodClass.getDeclaredMethods();
        for (methodIndex = 0; methodIndex < declaredMethods.length && !declaredMethods[methodIndex].equals(refMethod); ++methodIndex) {
        }
        String className = ASMFactoryUtils.getCreateClassNamePrefix(methodClass.getName()) + CLASS_POSTFIX_NAME + name + methodIndex;
        try {
            ClassLoader targetClassLoader = classLoader == null ? ASMFactoryUtils.getClassTargetLoader(methodClass) : classLoader;
            String classInternalName = className.replace('.', '/');
            ClassWriter cw = new ClassWriter(1);
            cw.visit(49, 1, classInternalName, null, superClass, null);
            ASMMethodFactory.createCtor(cw, superClass);
            ASMMethodFactory.createMethod(refMethod.getDeclaringClass(), refMethod.getName(), refMethod, cw, name, desc, argsParams, returnValue, refMethod.getParameterTypes());
            cw.visitEnd();
            byte[] b = cw.toByteArray();
            Class definedClass = ASMFactoryUtils.defineClass(targetClassLoader, className, b);
            return (T)((IProcedure)definedClass.getConstructor(Method.class).newInstance(refMethod));
        }
        catch (Exception e) {
            NoSuchMethodException ex = new NoSuchMethodException("Failed generating ASM method wrapper: " + e.toString());
            ex.initCause(e);
            throw ex;
        }
    }

    public static synchronized IMethod getMethod(Method refMethod) throws SecurityException, NoSuchMethodException {
        return ASMMethodFactory.getMethod(null, refMethod);
    }

    public static synchronized IMethod getMethod(ClassLoader classLoader, Method refMethod) throws SecurityException, NoSuchMethodException {
        return (IMethod)ASMMethodFactory.getProcedure(classLoader, refMethod, "internalInvoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", AbstractMethod.INTERNAL_NAME, true, true);
    }

    public static synchronized IGetterMethod getGetterMethod(Method refMethod) throws SecurityException, NoSuchMethodException {
        return ASMMethodFactory.getGetterMethod(null, refMethod);
    }

    public static synchronized IGetterMethod getGetterMethod(ClassLoader classLoader, Method refMethod) throws SecurityException, NoSuchMethodException {
        return (IGetterMethod)ASMMethodFactory.getProcedure(classLoader, refMethod, "internalGet", "(Ljava/lang/Object;)Ljava/lang/Object;", AbstractGetterMethod.INTERNAL_NAME, false, true);
    }

    public static synchronized ISetterMethod getSetterMethod(Method refMethod) throws SecurityException, NoSuchMethodException {
        return ASMMethodFactory.getSetterMethod(null, refMethod);
    }

    public static synchronized ISetterMethod getSetterMethod(ClassLoader classLoader, Method refMethod) throws SecurityException, NoSuchMethodException {
        return (ISetterMethod)ASMMethodFactory.getProcedure(classLoader, refMethod, "internalSet", "(Ljava/lang/Object;Ljava/lang/Object;)V", AbstractSetterMethod.INTERNAL_NAME, false, false);
    }

    private static void createCtor(ClassWriter cw, String superClass) {
        MethodGenerator mv = MethodGenerator.newConstructor((ClassVisitor)cw, "(Ljava/lang/reflect/Method;)V");
        mv.start();
        mv.loadThis();
        mv.loadVariable(1);
        mv.invokeConstructor(superClass, "(Ljava/lang/reflect/Method;)V");
        mv.returnVoid();
    }

    private static void createMethod(Class clazz, String name, Method refMethod, ClassWriter cw, String methodName, String desc, boolean argsParams, boolean returnValue, Class ... parameterTypes) {
        int invokeCode;
        MethodGenerator mv = MethodGenerator.newVarargsMethod((ClassVisitor)cw, methodName, desc, null);
        boolean isStatic = Modifier.isStatic(refMethod.getModifiers());
        boolean isInteface = Modifier.isInterface(refMethod.getDeclaringClass().getModifiers());
        if (isStatic) {
            invokeCode = 184;
        } else {
            invokeCode = isInteface ? 185 : 182;
            mv.castVariable(1, Type.getInternalName((Class)clazz));
        }
        if (argsParams) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                mv.loadArrayItemFromVariable(2, i);
                mv.unboxIfNeeded(parameterTypes[i]);
            }
        } else {
            for (int i = 0; i < parameterTypes.length; ++i) {
                mv.loadVariable(i + 2);
                mv.unboxIfNeeded(parameterTypes[i]);
            }
        }
        mv.invokeMethodCustom(invokeCode, Type.getInternalName((Class)clazz), name, Type.getMethodDescriptor((Method)refMethod));
        if (returnValue) {
            mv.prepareResult(refMethod.getReturnType());
            mv.returnObject();
        } else {
            mv.returnVoid();
        }
    }
}

