/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.fast;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.reflection.IProperties;
import com.gigaspaces.internal.reflection.fast.ASMFactoryUtils;
import com.gigaspaces.internal.reflection.fast.MethodGenerator;
import com.gigaspaces.internal.reflection.standard.StandardProperties;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.objectweb.gs.asm.ClassVisitor;
import org.objectweb.gs.asm.ClassWriter;
import org.objectweb.gs.asm.Label;
import org.objectweb.gs.asm.Type;

@InternalApi
public class ASMPropertiesFactory {
    private static final String CLASS_PROPERTIES_POSTFIX_NAME = "GigaspacesProperties";

    public static synchronized <T> IProperties<T> getProperties(SpaceTypeInfo typeInfo) throws SecurityException, NoSuchMethodException {
        String className = ASMFactoryUtils.getCreateClassNamePrefix(typeInfo.getName()) + CLASS_PROPERTIES_POSTFIX_NAME;
        try {
            ClassLoader targetClassLoader = ASMFactoryUtils.getClassTargetLoader(typeInfo.getType());
            ClassWriter cw = new ClassWriter(1);
            cw.visit(49, 1, className.replace('.', '/'), null, StandardProperties.INTERNAL_NAME, null);
            String ownerClassNameInternalName = Type.getInternalName(typeInfo.getType());
            ASMPropertiesFactory.createConstructor(cw);
            ASMPropertiesFactory.createGetter(cw, ownerClassNameInternalName, typeInfo.getSpaceProperties());
            ASMPropertiesFactory.createSetter(cw, ownerClassNameInternalName, typeInfo.getSpaceProperties());
            cw.visitEnd();
            byte[] b = cw.toByteArray();
            Class definedClass = ASMFactoryUtils.defineClass(targetClassLoader, className, b);
            Object[] constructorArgs = new Object[]{typeInfo.getSpaceProperties()};
            return (IProperties)definedClass.getConstructor(SpacePropertyInfo[].class).newInstance(constructorArgs);
        }
        catch (Exception e) {
            NoSuchMethodException ex = new NoSuchMethodException("Failed generating ASM properties wrapper: " + e.toString());
            ex.initCause(e);
            throw ex;
        }
    }

    private static void createConstructor(ClassWriter cw) {
        MethodGenerator mv = MethodGenerator.newConstructor((ClassVisitor)cw, "([Lcom/gigaspaces/internal/metadata/SpacePropertyInfo;)V");
        mv.start();
        mv.loadThis();
        mv.loadVariable(1);
        mv.invokeConstructor(StandardProperties.INTERNAL_NAME, "([Lcom/gigaspaces/internal/metadata/SpacePropertyInfo;)V");
        mv.returnVoid();
    }

    private static void createGetter(ClassWriter cw, String ownerTypeName, SpacePropertyInfo[] properties) {
        MethodGenerator mv = MethodGenerator.newMethod((ClassVisitor)cw, IProperties.Helper.getterName(), IProperties.Helper.getterDesc(), IProperties.Helper.exceptions());
        boolean VAR_OBJ = true;
        int VAR_POJO = 2;
        int VAR_RESULT = 3;
        mv.castVariableIntoVariable(1, ownerTypeName, 2);
        mv.newArray("java/lang/Object", properties.length);
        mv.storeVariable(3);
        for (int i = 0; i < properties.length; ++i) {
            Method getter = properties[i].getGetterMethod();
            mv.loadVariable(3);
            mv.loadConstant(i);
            if (Modifier.isPrivate(getter.getModifiers())) {
                mv.loadThis();
                mv.loadVariable(2);
                mv.loadConstant(i);
                mv.invokeMethod(StandardProperties.INTERNAL_NAME, "getValue", "(Ljava/lang/Object;I)Ljava/lang/Object;");
            } else {
                mv.loadVariable(2);
                mv.invokeMethod(ownerTypeName, getter.getName(), Type.getMethodDescriptor((Method)getter));
                mv.boxIfNeeded(getter.getReturnType());
            }
            mv.storeArrayItem();
        }
        mv.loadVariable(3);
        mv.returnObject();
    }

    private static void createSetter(ClassWriter cw, String ownerTypeName, SpacePropertyInfo[] properties) {
        MethodGenerator mv = MethodGenerator.newMethod((ClassVisitor)cw, IProperties.Helper.setterName(), IProperties.Helper.setterDesc());
        boolean VAR_OBJ = true;
        int VAR_VALUES = 2;
        int VAR_POJO = 3;
        mv.castVariableIntoVariable(1, ownerTypeName, 3);
        for (int i = 0; i < properties.length; ++i) {
            Method setter = properties[i].getSetterMethod();
            if (setter == null) continue;
            if (Modifier.isPrivate(setter.getModifiers())) {
                mv.loadThis();
                mv.loadVariable(3);
                mv.loadArrayItemFromVariable(2, i);
                mv.loadConstant(i);
                mv.invokeMethod(StandardProperties.INTERNAL_NAME, "setValue", "(Ljava/lang/Object;Ljava/lang/Object;I)V");
                continue;
            }
            if (!properties[i].isPrimitive()) {
                ASMPropertiesFactory.generateSetter(mv, ownerTypeName, setter, i, 3, 2);
                continue;
            }
            if (properties[i].hasNullValue()) {
                ASMPropertiesFactory.generateSetterWithNullValue(mv, ownerTypeName, setter, i, 3, 2);
                continue;
            }
            mv.loadArrayItemFromVariable(2, i);
            Label nullValueLabel = mv.jumpIfNull();
            ASMPropertiesFactory.generateSetter(mv, ownerTypeName, setter, i, 3, 2);
            mv.endIf(nullValueLabel);
        }
        mv.returnVoid();
    }

    private static void generateSetter(MethodGenerator mv, String ownerTypeName, Method setter, int propertyId, int pojoVariableId, int valuesVariableId) {
        mv.loadVariable(pojoVariableId);
        mv.loadArrayItemFromVariable(valuesVariableId, propertyId);
        mv.unboxIfNeeded(setter.getParameterTypes()[0]);
        mv.invokeMethod(ownerTypeName, setter.getName(), Type.getMethodDescriptor((Method)setter));
        if (setter.getReturnType() != Void.TYPE) {
            mv.pop();
        }
    }

    private static void generateSetterWithNullValue(MethodGenerator mv, String ownerTypeName, Method setter, int propertyId, int pojoVariableId, int valuesVariableId) {
        mv.loadVariable(pojoVariableId);
        mv.loadThis();
        mv.loadArrayItemFromVariable(valuesVariableId, propertyId);
        mv.loadConstant(propertyId);
        mv.invokeMethod(StandardProperties.INTERNAL_NAME, "convertFromNullIfNeeded", "(Ljava/lang/Object;I)Ljava/lang/Object;");
        mv.unboxIfNeeded(setter.getParameterTypes()[0]);
        mv.invokeMethod(ownerTypeName, setter.getName(), Type.getMethodDescriptor((Method)setter));
        if (setter.getReturnType() != Void.TYPE) {
            mv.pop();
        }
    }
}

