/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.fast;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.reflection.AbstractReflectionFactory;
import com.gigaspaces.internal.reflection.IConstructor;
import com.gigaspaces.internal.reflection.IField;
import com.gigaspaces.internal.reflection.IGetterMethod;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.IParamsConstructor;
import com.gigaspaces.internal.reflection.IProperties;
import com.gigaspaces.internal.reflection.IReflectionFactory;
import com.gigaspaces.internal.reflection.ISetterMethod;
import com.gigaspaces.internal.reflection.ProxyInvocationHandler;
import com.gigaspaces.internal.reflection.fast.ASMConstructorFactory;
import com.gigaspaces.internal.reflection.fast.ASMFieldFactory;
import com.gigaspaces.internal.reflection.fast.ASMFieldPropertiesFactory;
import com.gigaspaces.internal.reflection.fast.ASMMethodFactory;
import com.gigaspaces.internal.reflection.fast.ASMPropertiesFactory;
import com.gigaspaces.internal.reflection.fast.ConstructorPropertyNameExtractor;
import com.gigaspaces.internal.reflection.fast.proxy.ProxyFactory;
import com.gigaspaces.internal.reflection.standard.StandardReflectionFactory;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ASMReflectionFactory
extends AbstractReflectionFactory {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.reflection");
    private final IReflectionFactory _fallbackFactory = new StandardReflectionFactory();

    @Override
    public <T> IConstructor<T> getConstructor(Constructor<T> ctor) {
        block3: {
            if (ASMReflectionFactory.canGenerateAsm(ctor)) {
                try {
                    return ASMConstructorFactory.getConstructor(ctor);
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.WARNING)) break block3;
                    _logger.log(Level.WARNING, "Failed to generate ASM for constructor, falling back to standard reflection. class: " + ctor.getDeclaringClass().getName(), e);
                }
            }
        }
        return this._fallbackFactory.getConstructor(ctor);
    }

    @Override
    public <T> IParamsConstructor<T> getParamsConstructor(Constructor<T> ctor) {
        block3: {
            if (ASMReflectionFactory.canGenerateAsm(ctor)) {
                try {
                    return ASMConstructorFactory.getParamsConstructor(ctor);
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.WARNING)) break block3;
                    _logger.log(Level.WARNING, "Failed to generate ASM for constructor, falling back to standard reflection. class: " + ctor.getDeclaringClass().getName(), e);
                }
            }
        }
        return this._fallbackFactory.getParamsConstructor(ctor);
    }

    @Override
    public <T> String[] getConstructorParametersNames(Constructor<T> ctor) {
        try {
            return ConstructorPropertyNameExtractor.getParameterNames(ctor);
        }
        catch (IOException e) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Failed to get constructor parameters names using ASM, falling back to standard reflection. class: " + ctor.getDeclaringClass().getName(), e);
            }
            return this._fallbackFactory.getConstructorParametersNames(ctor);
        }
    }

    @Override
    public <T> IMethod<T> getMethod(ClassLoader classLoader, Method method) {
        block3: {
            if (ASMReflectionFactory.canGenerateAsm(method)) {
                try {
                    return ASMMethodFactory.getMethod(classLoader, method);
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.WARNING)) break block3;
                    _logger.log(Level.WARNING, "Failed to generate ASM for method, falling back to standard reflection. class: [" + method.getDeclaringClass().getName() + "], method: [" + method.getName() + "].", e);
                }
            }
        }
        return this._fallbackFactory.getMethod(classLoader, method);
    }

    @Override
    public <T> IGetterMethod<T> getGetterMethod(ClassLoader classLoader, Method method) {
        block3: {
            if (ASMReflectionFactory.canGenerateAsm(method)) {
                try {
                    return ASMMethodFactory.getGetterMethod(classLoader, method);
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.WARNING)) break block3;
                    _logger.log(Level.WARNING, "Failed to generate ASM for getter method, falling back to standard reflection. class: [" + method.getDeclaringClass().getName() + "], method: [" + method.getName() + "].", e);
                }
            }
        }
        return this._fallbackFactory.getGetterMethod(classLoader, method);
    }

    @Override
    public <T> ISetterMethod<T> getSetterMethod(ClassLoader classLoader, Method method) {
        block3: {
            if (ASMReflectionFactory.canGenerateAsm(method)) {
                try {
                    return ASMMethodFactory.getSetterMethod(classLoader, method);
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.WARNING)) break block3;
                    _logger.log(Level.WARNING, "Failed to generate ASM for setter method, falling back to standard reflection. class: [" + method.getDeclaringClass().getName() + "], method: [" + method.getName() + "].", e);
                }
            }
        }
        return this._fallbackFactory.getSetterMethod(classLoader, method);
    }

    @Override
    public <T, F> IField<T, F> getField(Field field) {
        block3: {
            if (ASMReflectionFactory.canGenerateAsm(field)) {
                try {
                    return ASMFieldFactory.getField(field);
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.WARNING)) break block3;
                    _logger.log(Level.WARNING, "Failed to generate ASM for field, falling back to standard reflection. class: [" + field.getDeclaringClass().getName() + "], method: [" + field.getName() + "].", e);
                }
            }
        }
        return this._fallbackFactory.getField(field);
    }

    @Override
    public <T> IProperties<T> getFieldProperties(Class<T> declaringClass, Field[] fields) {
        try {
            return ASMFieldPropertiesFactory.getProperties(declaringClass, fields);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Failed to generate ASM for properties, falling back to standard reflection. class: [" + declaringClass.getName() + "].", e);
            }
            return this._fallbackFactory.getFieldProperties(declaringClass, fields);
        }
    }

    @Override
    public <T> IProperties<T> getProperties(SpaceTypeInfo typeInfo) {
        try {
            return ASMPropertiesFactory.getProperties(typeInfo);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Failed to generate ASM for properties, falling back to standard reflection. class: [" + typeInfo.getName() + "].", e);
            }
            return this._fallbackFactory.getProperties(typeInfo);
        }
    }

    @Override
    public Object getProxy(ClassLoader loader, Class<?>[] interfaces, ProxyInvocationHandler handler, boolean allowCache) {
        try {
            return ProxyFactory.newProxyInstance(loader, interfaces, handler, allowCache);
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "Failed to generate ASM for dynamic proxy, falling back to standard reflection. ", e);
            }
            return this._fallbackFactory.getProxy(loader, interfaces, handler, allowCache);
        }
    }

    private static boolean canGenerateAsm(Member member) {
        if (!Modifier.isPrivate(member.getModifiers()) && member.getDeclaringClass().getClassLoader() != null) {
            return true;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Cannot generate ASM for member " + member.getName() + " on class " + member.getDeclaringClass().getName() + " - using standard reflection instead.");
        }
        return false;
    }
}

