/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.fast;

import com.gigaspaces.api.InternalApi;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.objectweb.gs.asm.AnnotationVisitor;
import org.objectweb.gs.asm.Attribute;
import org.objectweb.gs.asm.ClassReader;
import org.objectweb.gs.asm.ClassVisitor;
import org.objectweb.gs.asm.FieldVisitor;
import org.objectweb.gs.asm.Label;
import org.objectweb.gs.asm.MethodVisitor;
import org.objectweb.gs.asm.Type;

@InternalApi
public class ConstructorPropertyNameExtractor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getParameterNames(Constructor<?> constructor) throws IOException {
        Class<?> declaringClass = constructor.getDeclaringClass();
        ClassLoader classLoader = declaringClass.getClassLoader();
        if (classLoader == null) {
            throw new IllegalArgumentException("No class loader found for declaring class: " + declaringClass);
        }
        Type declaringType = Type.getType(declaringClass);
        String constructorDescriptor = Type.getConstructorDescriptor(constructor);
        String url = declaringType.getInternalName() + ".class";
        InputStream classFileInputStream = classLoader.getResourceAsStream(url);
        if (classFileInputStream == null) {
            throw new IllegalArgumentException("The constructor's class loader cannot find the bytecode that defined the constructor's class (URL: " + url + ")");
        }
        ParameterNameExtractorClassVisitor extractor = new ParameterNameExtractorClassVisitor(constructorDescriptor);
        try {
            ClassReader classReader = new ClassReader(classFileInputStream);
            classReader.accept((ClassVisitor)extractor, 0);
        }
        finally {
            classFileInputStream.close();
        }
        return extractor.parameterNames;
    }

    private static class ParameterNameExtractorMethodVisitor
    implements MethodVisitor {
        private final int numberOfParameters;
        private final String[] parameterNames;
        private int currentIndex = 0;

        public ParameterNameExtractorMethodVisitor(int numberOfParameters, String[] parameterNames) {
            this.numberOfParameters = numberOfParameters;
            this.parameterNames = parameterNames;
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (index < 1 || this.currentIndex >= this.numberOfParameters || name == null) {
                return;
            }
            this.parameterNames[this.currentIndex] = name;
            ++this.currentIndex;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return null;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitCode() {
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        }

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitVarInsn(int opcode, int var) {
        }

        public void visitTypeInsn(int opcode, String type) {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitLdcInsn(Object cst) {
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        public void visitLineNumber(int line, Label start) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visitEnd() {
        }
    }

    private static class ParameterNameExtractorClassVisitor
    implements ClassVisitor {
        private static final String CONSTRUCTOR_METHOD_NAME = "<init>";
        private final String constructorDescription;
        private final String[] parameterNames;
        private final Type[] argumentTypes;

        ParameterNameExtractorClassVisitor(String constructorDescription) {
            this.constructorDescription = constructorDescription;
            this.argumentTypes = Type.getArgumentTypes((String)constructorDescription);
            this.parameterNames = new String[this.argumentTypes.length];
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (!CONSTRUCTOR_METHOD_NAME.equals(name) || !this.constructorDescription.equals(desc)) {
                return null;
            }
            return new ParameterNameExtractorMethodVisitor(this.argumentTypes.length, this.parameterNames);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        public void visitSource(String source, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        public void visitEnd() {
        }
    }
}

