/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.fast;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.reflection.fast.Boxer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.objectweb.gs.asm.ClassVisitor;
import org.objectweb.gs.asm.Label;
import org.objectweb.gs.asm.MethodVisitor;
import org.objectweb.gs.asm.Type;

@InternalApi
public class MethodGenerator {
    private final MethodVisitor mv;

    private MethodGenerator(ClassVisitor classVisitor, int access, String name, String desc, String signature, String[] exceptions) {
        this.mv = classVisitor.visitMethod(access, name, desc, signature, exceptions);
    }

    public static MethodGenerator newConstructor(ClassVisitor classVisitor, String desc) {
        return new MethodGenerator(classVisitor, 1, "<init>", desc, null, null);
    }

    public static MethodGenerator newStaticConstructor(ClassVisitor classVisitor, String desc) {
        return new MethodGenerator(classVisitor, 8, "<clinit>", desc, null, null);
    }

    public static MethodGenerator newMethod(ClassVisitor classVisitor, String name, String desc) {
        return new MethodGenerator(classVisitor, 1, name, desc, null, null);
    }

    public static MethodGenerator newMethod(ClassVisitor classVisitor, String name, String desc, String[] exceptions) {
        return new MethodGenerator(classVisitor, 1, name, desc, null, exceptions);
    }

    public static MethodGenerator newVarargsMethod(ClassVisitor classVisitor, String name, String desc, String[] exceptions) {
        return new MethodGenerator(classVisitor, 129, name, desc, null, exceptions);
    }

    public void returnVoid() {
        this.returnResult(177);
    }

    public void returnObject() {
        this.returnResult(176);
    }

    public void returnInt() {
        this.returnResult(172);
    }

    public void returnLong() {
        this.returnResult(173);
    }

    public void returnFloat() {
        this.returnResult(174);
    }

    public void returnDouble() {
        this.returnResult(175);
    }

    public void returnResult(Class clazz) {
        Type type = Type.getType((Class)clazz);
        switch (type.getSort()) {
            case 0: {
                this.returnVoid();
                break;
            }
            case 1: {
                this.checkCast("java/lang/Boolean");
                this.invokeMethod("java/lang/Boolean", "booleanValue", "()Z");
                this.returnInt();
                break;
            }
            case 3: {
                this.checkCast("java/lang/Byte");
                this.invokeMethod("java/lang/Byte", "byteValue", "()B");
                this.returnInt();
                break;
            }
            case 2: {
                this.checkCast("java/lang/Character");
                this.invokeMethod("java/lang/Character", "charValue", "()C");
                this.returnInt();
                break;
            }
            case 4: {
                this.checkCast("java/lang/Short");
                this.invokeMethod("java/lang/Short", "shortValue", "()S");
                this.returnInt();
                break;
            }
            case 5: {
                this.checkCast("java/lang/Integer");
                this.invokeMethod("java/lang/Integer", "intValue", "()I");
                this.returnInt();
                break;
            }
            case 7: {
                this.checkCast("java/lang/Long");
                this.invokeMethod("java/lang/Long", "longValue", "()J");
                this.returnLong();
                break;
            }
            case 6: {
                this.checkCast("java/lang/Float");
                this.invokeMethod("java/lang/Float", "floatValue", "()F");
                this.returnFloat();
                break;
            }
            case 8: {
                this.checkCast("java/lang/Double");
                this.invokeMethod("java/lang/Double", "doubleValue", "()D");
                this.returnDouble();
                break;
            }
            default: {
                this.checkCast(type.getInternalName());
                this.returnObject();
            }
        }
    }

    private void returnResult(int opcode) {
        this.mv.visitInsn(opcode);
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
    }

    public void loadField(Class owner, Field field) {
        int getOpCode = Modifier.isStatic(field.getModifiers()) ? 178 : 180;
        this.mv.visitFieldInsn(getOpCode, Type.getInternalName((Class)owner), field.getName(), Type.getDescriptor(field.getType()));
    }

    public void storeField(Class owner, Field field) {
        int putOpCode = Modifier.isStatic(field.getModifiers()) ? 179 : 181;
        this.mv.visitFieldInsn(putOpCode, Type.getInternalName((Class)owner), field.getName(), Type.getDescriptor(field.getType()));
    }

    public void loadField(String internalClassName, String name, String descriptor) {
        this.mv.visitFieldInsn(180, internalClassName, name, descriptor);
    }

    public void storeField(String internalClassName, String name, String descriptor) {
        this.mv.visitFieldInsn(181, internalClassName, name, descriptor);
    }

    public void loadStaticField(String internalClassName, String name, String descriptor) {
        this.mv.visitFieldInsn(178, internalClassName, name, descriptor);
    }

    public void storeStaticField(String internalClassName, String name, String descriptor) {
        this.mv.visitFieldInsn(179, internalClassName, name, descriptor);
    }

    public void loadVariable(int varIndex) {
        this.mv.visitVarInsn(25, varIndex);
    }

    public void loadThis() {
        this.mv.visitVarInsn(25, 0);
    }

    public void loadVariableInt(int varIndex) {
        this.mv.visitVarInsn(21, varIndex);
    }

    public void storeVariable(int varIndex) {
        this.mv.visitVarInsn(58, varIndex);
    }

    public int loadVariable(Class type, int index) {
        int sort = Type.getType((Class)type).getSort();
        switch (sort) {
            case 1: {
                this.mv.visitVarInsn(21, index);
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(Z)Ljava/lang/Object;");
                return 1;
            }
            case 3: {
                this.mv.visitVarInsn(21, index);
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(B)Ljava/lang/Object;");
                return 1;
            }
            case 2: {
                this.mv.visitVarInsn(21, index);
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(C)Ljava/lang/Object;");
                return 1;
            }
            case 4: {
                this.mv.visitVarInsn(21, index);
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(S)Ljava/lang/Object;");
                return 1;
            }
            case 5: {
                this.mv.visitVarInsn(21, index);
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(I)Ljava/lang/Object;");
                return 1;
            }
            case 7: {
                this.mv.visitVarInsn(22, index);
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(J)Ljava/lang/Object;");
                return 2;
            }
            case 6: {
                this.mv.visitVarInsn(23, index);
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(F)Ljava/lang/Object;");
                return 1;
            }
            case 8: {
                this.mv.visitVarInsn(24, index);
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(D)Ljava/lang/Object;");
                return 2;
            }
        }
        this.loadVariable(index);
        return 1;
    }

    public void loadArrayItem() {
        this.mv.visitInsn(50);
    }

    public void loadArrayItemFromVariable(int variablePos, int index) {
        this.loadVariable(variablePos);
        this.loadConstant(index);
        this.loadArrayItem();
    }

    public void storeArrayItem() {
        this.mv.visitInsn(83);
    }

    public void invokeMethod(String owner, String name, String desc) {
        this.invokeMethodCustom(182, owner, name, desc);
    }

    public void invokeStaticMethod(String owner, String name, String desc) {
        this.invokeMethodCustom(184, owner, name, desc);
    }

    public void invokeConstructor(String owner, String desc) {
        this.invokeMethodCustom(183, owner, "<init>", desc);
    }

    public void invokeMethodCustom(int opcode, String owner, String name, String desc) {
        this.mv.visitMethodInsn(opcode, owner, name, desc);
    }

    public void newInstance(String className) {
        this.mv.visitTypeInsn(187, className);
    }

    public void newArray(String className, int length) {
        this.loadConstant(length);
        this.mv.visitTypeInsn(189, className);
    }

    public void checkCast(String className) {
        this.mv.visitTypeInsn(192, className);
    }

    public void castVariable(int varIndex, String className) {
        this.loadVariable(varIndex);
        this.checkCast(className);
    }

    public void castVariableIntoVariable(int sourceVarIndex, String className, int targetVarIndex) {
        this.castVariable(sourceVarIndex, className);
        this.storeVariable(targetVarIndex);
    }

    public Label jumpIfNull() {
        Label label = new Label();
        this.mv.visitJumpInsn(198, label);
        return label;
    }

    public void endIf(Label label) {
        this.mv.visitLabel(label);
    }

    public void start() {
        this.mv.visitCode();
    }

    public void dup() {
        this.mv.visitInsn(89);
    }

    public void pop() {
        this.mv.visitInsn(87);
    }

    public void loadConstant(Object value) {
        this.mv.visitLdcInsn(value);
    }

    public void unboxIfNeeded(Class clazz) {
        Type type = Type.getType((Class)clazz);
        switch (Type.getType((Class)clazz).getSort()) {
            case 1: {
                this.checkCast("java/lang/Boolean");
                this.invokeMethod("java/lang/Boolean", "booleanValue", "()Z");
                break;
            }
            case 3: {
                this.checkCast("java/lang/Byte");
                this.invokeMethod("java/lang/Byte", "byteValue", "()B");
                break;
            }
            case 2: {
                this.checkCast("java/lang/Character");
                this.invokeMethod("java/lang/Character", "charValue", "()C");
                break;
            }
            case 4: {
                this.checkCast("java/lang/Short");
                this.invokeMethod("java/lang/Short", "shortValue", "()S");
                break;
            }
            case 5: {
                this.checkCast("java/lang/Integer");
                this.invokeMethod("java/lang/Integer", "intValue", "()I");
                break;
            }
            case 7: {
                this.checkCast("java/lang/Long");
                this.invokeMethod("java/lang/Long", "longValue", "()J");
                break;
            }
            case 6: {
                this.checkCast("java/lang/Float");
                this.invokeMethod("java/lang/Float", "floatValue", "()F");
                break;
            }
            case 8: {
                this.checkCast("java/lang/Double");
                this.invokeMethod("java/lang/Double", "doubleValue", "()D");
                break;
            }
            default: {
                this.checkCast(type.getInternalName());
            }
        }
    }

    public void boxIfNeeded(Class clazz) {
        if (!clazz.isPrimitive()) {
            return;
        }
        int sort = Type.getType((Class)clazz).getSort();
        switch (sort) {
            case 1: {
                this.invokeStaticMethod("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 3: {
                this.invokeStaticMethod("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                break;
            }
            case 2: {
                this.invokeStaticMethod("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                break;
            }
            case 4: {
                this.invokeStaticMethod("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                break;
            }
            case 5: {
                this.invokeStaticMethod("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                break;
            }
            case 7: {
                this.invokeStaticMethod("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                break;
            }
            case 6: {
                this.invokeStaticMethod("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                break;
            }
            case 8: {
                this.invokeStaticMethod("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            }
        }
    }

    public void prepareResult(Class clazz) {
        Type type = Type.getType((Class)clazz);
        switch (type.getSort()) {
            case 0: {
                this.mv.visitInsn(1);
                break;
            }
            case 1: {
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(Z)Ljava/lang/Object;");
                break;
            }
            case 3: {
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(B)Ljava/lang/Object;");
                break;
            }
            case 2: {
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(C)Ljava/lang/Object;");
                break;
            }
            case 4: {
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(S)Ljava/lang/Object;");
                break;
            }
            case 5: {
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(I)Ljava/lang/Object;");
                break;
            }
            case 7: {
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(J)Ljava/lang/Object;");
                break;
            }
            case 6: {
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(F)Ljava/lang/Object;");
                break;
            }
            case 8: {
                this.invokeStaticMethod(Boxer.INTERNAL_NAME, "box", "(D)Ljava/lang/Object;");
            }
        }
    }
}

