/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.fast.proxy;

import com.gigaspaces.internal.reflection.IDynamicProxy;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.MethodHolder;
import com.gigaspaces.internal.reflection.ProxyInvocationHandler;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.stubcache.MissingCachedStubException;
import com.gigaspaces.internal.stubcache.StubId;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.ILRMIProxy;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.LRMIRuntime;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractProxy
implements Serializable,
IDynamicProxy {
    private static final long serialVersionUID = -7155145351229271987L;
    private static final Logger _stubCacheLogger = Logger.getLogger("com.gigaspaces.lrmi.stubcache");
    public static final String INTERNAL_NAME = ReflectionUtil.getInternalName(AbstractProxy.class);
    private static final Method EQUAL_METHOD;
    private static final Method HASHCODE_METHOD;
    private static final Method TOSTRING_METHOD;
    protected final ProxyInvocationHandler _handler;
    private final ProxyReplace _fullSerializationObjectUncached;
    private final boolean _allowCache;
    private final boolean _cacheable;
    private LightProxyReplace _lightSerializationObject;

    public AbstractProxy(ProxyInvocationHandler handler, boolean allowCache) {
        this._handler = handler;
        this._fullSerializationObjectUncached = new ProxyReplace(this.getClass().getInterfaces(), this.getInvocatioHandler(), false, allowCache, this);
        this._allowCache = allowCache;
        this._cacheable = this._allowCache && handler instanceof ILRMIProxy;
    }

    @Override
    public ProxyInvocationHandler getInvocatioHandler() {
        return this._handler;
    }

    public Object writeReplace() throws ObjectStreamException {
        if (!this._cacheable) {
            return this._fullSerializationObjectUncached;
        }
        LRMIInvocationContext currentContext = LRMIInvocationContext.getCurrentContext();
        LRMIInvocationContext.ProxyWriteType proxyWriteType = currentContext.getProxyWriteType();
        if (proxyWriteType != LRMIInvocationContext.ProxyWriteType.UNCACHED && !currentContext.isUseStubCache()) {
            proxyWriteType = LRMIInvocationContext.ProxyWriteType.UNCACHED;
        }
        switch (proxyWriteType) {
            case UNCACHED: {
                if (_stubCacheLogger.isLoggable(Level.FINER)) {
                    _stubCacheLogger.finer("serializing full uncached stub, toString() = " + this.toString());
                }
                return this._fullSerializationObjectUncached;
            }
            case CACHED_LIGHT: {
                if (this._lightSerializationObject != null) {
                    if (_stubCacheLogger.isLoggable(Level.FINEST)) {
                        _stubCacheLogger.finest("serializing light stub with id = " + ((ILRMIProxy)((Object)this._handler)).getStubId() + ", stub toString() = " + this.toString());
                    }
                    return this._lightSerializationObject;
                }
            }
            case CACHED_FULL: {
                if (_stubCacheLogger.isLoggable(Level.FINE)) {
                    _stubCacheLogger.fine("serializing full stub for caching with id = " + ((ILRMIProxy)((Object)this._handler)).getStubId() + ", stub toString() = " + this.toString());
                }
                return new ProxyReplace(this.getClass().getInterfaces(), this.getInvocatioHandler(), true, true, this);
            }
        }
        throw new RuntimeException("Unexpected ProxyWriteType received " + proxyWriteType);
    }

    protected static IMethod[] getIMethods(Class clazz) {
        MethodHolder[] uniqueIMethods = AbstractProxy.getUniqueMethodHolders(clazz.getInterfaces());
        IMethod[] methods = new IMethod[uniqueIMethods.length];
        for (int i = 0; i < uniqueIMethods.length; ++i) {
            methods[i] = ReflectionUtil.createMethod(clazz.getClassLoader(), uniqueIMethods[i].getMethod());
        }
        return methods;
    }

    public static MethodHolder[] getUniqueMethodHolders(Class<?>[] interfaces) {
        HashSet<MethodHolder> set = new HashSet<MethodHolder>();
        for (Class<?> inter : interfaces) {
            for (Method method : inter.getMethods()) {
                set.add(new MethodHolder(method));
            }
        }
        set.add(new MethodHolder(EQUAL_METHOD));
        set.add(new MethodHolder(HASHCODE_METHOD));
        set.add(new MethodHolder(TOSTRING_METHOD));
        return set.toArray(new MethodHolder[set.size()]);
    }

    static {
        try {
            EQUAL_METHOD = Object.class.getDeclaredMethod("equals", Object.class);
            HASHCODE_METHOD = Object.class.getDeclaredMethod("hashCode", new Class[0]);
            TOSTRING_METHOD = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class LightProxyReplace
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private StubId _stubId;

        public LightProxyReplace() {
        }

        public LightProxyReplace(StubId stubId) {
            this._stubId = stubId;
        }

        public Object readResolve() throws ObjectStreamException {
            Object stub = LRMIRuntime.getRuntime().getStubCache().getStub(this._stubId);
            if (stub == null) {
                if (_stubCacheLogger.isLoggable(Level.FINEST)) {
                    _stubCacheLogger.finest("attempt to get stub from cache by id " + this._stubId + " no cached stub exist under that id");
                }
                throw new MissingCachedStubException(this._stubId);
            }
            if (_stubCacheLogger.isLoggable(Level.FINEST)) {
                _stubCacheLogger.finest("got stub from cache by id " + this._stubId + " result stub toString() = " + stub);
            }
            return stub;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this._stubId = (StubId)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this._stubId);
        }
    }

    public static class ProxyReplace
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private Class[] _interfaces;
        private ProxyInvocationHandler _handler;
        private boolean _allowCache;
        private boolean _cacheProxy;
        private transient AbstractProxy _replacingProxy;

        public ProxyReplace() {
        }

        public ProxyReplace(Class[] interfaces, ProxyInvocationHandler handler, boolean cacheProxy, boolean allowCache, AbstractProxy replacingProxy) {
            this._handler = handler;
            this._interfaces = interfaces;
            this._cacheProxy = cacheProxy;
            this._allowCache = allowCache;
            this._replacingProxy = replacingProxy;
        }

        protected Object createInstance(ClassLoader cl) {
            return ReflectionUtil.createProxy(cl, this._interfaces, this._handler, this._allowCache);
        }

        public Object readResolve() throws ObjectStreamException {
            ClassLoader cl = ReflectionUtil.getClassTargetLoader(this._interfaces[0]);
            Object proxyInstance = this.createInstance(cl);
            if (this._cacheProxy && this._handler instanceof ILRMIProxy) {
                StubId stubId = ((ILRMIProxy)((Object)this._handler)).getStubId();
                if (_stubCacheLogger.isLoggable(Level.FINE)) {
                    _stubCacheLogger.fine("adding stub to cache, id = " + stubId + ", stub toString() = " + proxyInstance);
                }
                LRMIRuntime.getRuntime().getStubCache().addStub(stubId, proxyInstance);
            } else if (_stubCacheLogger.isLoggable(Level.FINER)) {
                _stubCacheLogger.finer("stub state is uncached, skipping cache insertion. toString() = " + proxyInstance);
            }
            return proxyInstance;
        }

        Class<?>[] filterInterface(Class<?>[] interfaces) {
            ArrayList res = new ArrayList();
            PlatformLogicalVersion platformLogicalVersion = LRMIInvocationContext.getEndpointLogicalVersion();
            for (Class<?> anInterface : interfaces) {
                if (anInterface.getName().equals("com.gigaspaces.internal.cluster.node.impl.router.CallbackVerifier") && platformLogicalVersion.lessThan(PlatformLogicalVersion.v12_0_1)) continue;
                res.add(anInterface);
            }
            return res.toArray(new Class[res.size()]);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int arrayLength = in.readInt();
            this._interfaces = new Class[arrayLength];
            for (int i = 0; i < arrayLength; ++i) {
                this._interfaces[i] = (Class)in.readObject();
            }
            this._handler = (ProxyInvocationHandler)in.readObject();
            this._allowCache = in.readBoolean();
            this._cacheProxy = in.readBoolean();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            Class<?>[] actualInterfaces = this.filterInterface(this._interfaces);
            out.writeInt(actualInterfaces.length);
            for (Class<?> inter : actualInterfaces) {
                out.writeObject(inter);
            }
            out.writeObject(this._handler);
            out.writeBoolean(this._allowCache);
            out.writeBoolean(this._cacheProxy);
            if (this._cacheProxy) {
                this._replacingProxy._lightSerializationObject = new LightProxyReplace(((ILRMIProxy)((Object)this._handler)).getStubId());
            }
        }
    }
}

