/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.fast.proxy;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.classloader.ClassLoaderCache;
import com.gigaspaces.internal.classloader.IClassLoaderCacheStateListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class ProxyCache {
    private static final WeakReference<Class> PENDING_GENERATION_MARKER = new WeakReference<Object>(null);
    private static final Map<Long, Map<InterfacesKey, WeakReference<Class>>> loaderToCache = new HashMap<Long, Map<InterfacesKey, WeakReference<Class>>>();
    static final ClassLoaderCacheListener cacheStateListener = new ClassLoaderCacheListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ClassLoader loader, Class<?>[] interfaces, Class proxyClass) {
        Map<Long, Map<InterfacesKey, WeakReference<Class>>> map = loaderToCache;
        synchronized (map) {
            Map<InterfacesKey, WeakReference<Class>> cache;
            Long classLoaderKey = ClassLoaderCache.getCache().getClassLoaderKey(loader);
            Map<InterfacesKey, WeakReference<Class>> map2 = cache = loaderToCache.get(classLoaderKey);
            synchronized (map2) {
                InterfacesKey key = new InterfacesKey(interfaces);
                cache.put(key, new WeakReference<Class>(proxyClass));
                cache.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findInCache(ClassLoader loader, Class<?>[] interfaces) {
        Map<InterfacesKey, WeakReference<Class>> cache;
        Map<Long, Map<InterfacesKey, WeakReference<Class>>> map = loaderToCache;
        synchronized (map) {
            Long classLoaderKey = ClassLoaderCache.getCache().putClassLoader(loader);
            cache = loaderToCache.get(classLoaderKey);
            if (cache == null) {
                cache = new HashMap<InterfacesKey, WeakReference<Class>>();
                loaderToCache.put(classLoaderKey, cache);
            }
        }
        InterfacesKey key = new InterfacesKey(interfaces);
        Map<InterfacesKey, WeakReference<Class>> map2 = cache;
        synchronized (map2) {
            while (true) {
                WeakReference<Class> proxyRef = cache.get(key);
                Class proxyClass = null;
                if (proxyRef != null) {
                    proxyClass = (Class)proxyRef.get();
                }
                if (proxyClass != null) {
                    return proxyClass;
                }
                if (proxyRef != PENDING_GENERATION_MARKER) break;
                try {
                    cache.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted while waiting to find a proxy in cache.", e);
                }
            }
            cache.put(key, PENDING_GENERATION_MARKER);
            return null;
        }
    }

    static {
        ClassLoaderCache.getCache().registerCacheStateListener(cacheStateListener);
    }

    private static class InterfacesKey {
        private final Class<?>[] _interfaces;

        public InterfacesKey(Class<?>[] interfaces) {
            this._interfaces = interfaces;
        }

        public int hashCode() {
            if (this._interfaces.length > 0) {
                return this._interfaces[0].hashCode();
            }
            return 432543;
        }

        public boolean equals(Object obj) {
            InterfacesKey other = (InterfacesKey)obj;
            return Arrays.equals(this._interfaces, other._interfaces);
        }
    }

    private static class ClassLoaderCacheListener
    implements IClassLoaderCacheStateListener {
        private ClassLoaderCacheListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClassLoaderRemoved(Long classLoaderKey, boolean explicit) {
            Map map = loaderToCache;
            synchronized (map) {
                loaderToCache.remove(classLoaderKey);
            }
        }
    }
}

