/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.fast.proxy;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.MethodHolder;
import com.gigaspaces.internal.reflection.ProxyInvocationHandler;
import com.gigaspaces.internal.reflection.fast.ASMFactoryUtils;
import com.gigaspaces.internal.reflection.fast.MethodGenerator;
import com.gigaspaces.internal.reflection.fast.proxy.AbstractProxy;
import com.gigaspaces.internal.reflection.fast.proxy.ProxyCache;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicInteger;
import org.objectweb.gs.asm.ClassVisitor;
import org.objectweb.gs.asm.ClassWriter;
import org.objectweb.gs.asm.FieldVisitor;
import org.objectweb.gs.asm.Type;

@InternalApi
public class ProxyFactory {
    private static final String OBJECT_INTERNALNAME = Type.getInternalName(Object.class);
    private static final String CTOR_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(ProxyInvocationHandler.class), Type.BOOLEAN_TYPE});
    private static final AtomicInteger _proxyID = new AtomicInteger();
    private static final ProxyCache _proxyCache = new ProxyCache();

    public static Object newProxyInstance(ClassLoader loader, Class<?>[] interfaces, ProxyInvocationHandler handler, boolean allowCache) throws IllegalArgumentException {
        if (loader == null) {
            loader = AbstractProxy.class.getClassLoader();
        }
        Class definedClass = _proxyCache.findInCache(loader, interfaces);
        try {
            if (definedClass == null) {
                String packageName = ProxyFactory.getPackageName(interfaces);
                String className = packageName + ".$GSProxy" + _proxyID.getAndIncrement();
                String classInternalName = className.replace('.', '/');
                String[] interfacesName = new String[interfaces.length];
                for (int i = 0; i < interfaces.length; ++i) {
                    interfacesName[i] = Type.getInternalName(interfaces[i]);
                }
                ClassWriter cw = new ClassWriter(3);
                cw.visit(49, 33, classInternalName, null, AbstractProxy.INTERNAL_NAME, interfacesName);
                MethodHolder[] uniqueMethods = AbstractProxy.getUniqueMethodHolders(interfaces);
                ProxyFactory.createStaticCtor(cw, classInternalName);
                ProxyFactory.createCtor(cw);
                ProxyFactory.createMethods(cw, uniqueMethods, classInternalName);
                cw.visitEnd();
                byte[] b = cw.toByteArray();
                definedClass = ASMFactoryUtils.defineClass(loader, className, b);
                _proxyCache.add(loader, interfaces, definedClass);
            }
            Constructor ctor = definedClass.getConstructor(ProxyInvocationHandler.class, Boolean.TYPE);
            AbstractProxy proxy = (AbstractProxy)ctor.newInstance(handler, allowCache);
            return proxy;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String getPackageName(Class<?>[] interfaces) {
        String notPublicPackage = null;
        for (Class<?> inter : interfaces) {
            if (Modifier.isPublic(inter.getModifiers())) continue;
            if (notPublicPackage == null) {
                notPublicPackage = inter.getPackage().getName();
                continue;
            }
            if (notPublicPackage.equals(inter.getPackage().getName())) continue;
            throw new IllegalArgumentException("non-public interfaces from different packages");
        }
        return notPublicPackage == null ? "com.gigaspaces.reflect" : notPublicPackage;
    }

    private static void createMethods(ClassWriter cw, MethodHolder[] methods, String classInternalName) {
        for (int j = 0; j < methods.length; ++j) {
            MethodHolder method = methods[j];
            Class<?>[] exceptionTypes = method.getMethod().getExceptionTypes();
            String[] exceptions = new String[exceptionTypes.length];
            for (int i = 0; i < exceptionTypes.length; ++i) {
                exceptions[i] = Type.getInternalName(exceptionTypes[i]);
            }
            MethodGenerator mv = MethodGenerator.newVarargsMethod((ClassVisitor)cw, method.getName(), method.getMethodDescriptor(), exceptions);
            mv.start();
            mv.loadThis();
            mv.loadField(AbstractProxy.INTERNAL_NAME, "_handler", "L" + ProxyInvocationHandler.INTERNAL_NAME + ";");
            mv.loadThis();
            mv.loadStaticField(classInternalName, "_methods", IMethod.ARRAY_DESCRIPTOR_NAME);
            mv.loadConstant(j);
            mv.loadArrayItem();
            Class<?>[] parameterTypes = method.getMethod().getParameterTypes();
            mv.newArray(OBJECT_INTERNALNAME, parameterTypes.length);
            int argPos = 1;
            for (int i = 0; i < parameterTypes.length; ++i) {
                mv.dup();
                mv.loadConstant(i);
                argPos += mv.loadVariable(parameterTypes[i], argPos);
                mv.storeArrayItem();
            }
            mv.invokeMethodCustom(185, ProxyInvocationHandler.INTERNAL_NAME, "invoke", "(Ljava/lang/Object;" + IMethod.DESCRIPTOR_NAME + "[Ljava/lang/Object;)Ljava/lang/Object;");
            mv.returnResult(method.getMethod().getReturnType());
        }
    }

    private static void createStaticCtor(ClassWriter cw, String className) {
        FieldVisitor fv = cw.visitField(26, "_methods", IMethod.ARRAY_DESCRIPTOR_NAME, null, null);
        fv.visitEnd();
        MethodGenerator mv = MethodGenerator.newStaticConstructor((ClassVisitor)cw, "()V");
        mv.start();
        mv.loadConstant(Type.getType((String)("L" + className + ";")));
        mv.invokeStaticMethod(AbstractProxy.INTERNAL_NAME, "getIMethods", "(Ljava/lang/Class;)[Lcom/gigaspaces/internal/reflection/IMethod;");
        mv.storeStaticField(className, "_methods", IMethod.ARRAY_DESCRIPTOR_NAME);
        mv.returnVoid();
    }

    private static void createCtor(ClassWriter cw) {
        MethodGenerator mv = MethodGenerator.newConstructor((ClassVisitor)cw, CTOR_DESC);
        mv.start();
        mv.loadThis();
        mv.loadVariable(1);
        mv.loadVariableInt(2);
        mv.invokeConstructor(AbstractProxy.INTERNAL_NAME, CTOR_DESC);
        mv.returnVoid();
    }
}

