/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.standard;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.SpacePropertyInfo;
import com.gigaspaces.internal.reflection.IProperties;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;

@InternalApi
public class StandardProperties<T>
implements IProperties<T> {
    public static final String INTERNAL_NAME = ReflectionUtil.getInternalName(StandardProperties.class);
    public static final String CTOR_DESC = "([Lcom/gigaspaces/internal/metadata/SpacePropertyInfo;)V";
    public static final String GET_VALUE_NAME = "getValue";
    public static final String GET_VALUE_DESC = "(Ljava/lang/Object;I)Ljava/lang/Object;";
    public static final String SET_VALUE_NAME = "setValue";
    public static final String SET_VALUE_DESC = "(Ljava/lang/Object;Ljava/lang/Object;I)V";
    public static final String FROM_NULL_VALUE_NAME = "convertFromNullIfNeeded";
    public static final String FROM_NULL_VALUE_DESC = "(Ljava/lang/Object;I)Ljava/lang/Object;";
    private final SpacePropertyInfo[] _properties;

    public StandardProperties(SpacePropertyInfo[] properties) {
        this._properties = properties;
        for (SpacePropertyInfo property : properties) {
            if (!property.getGetterMethod().isAccessible()) {
                property.getGetterMethod().setAccessible(true);
            }
            if (property.getSetterMethod() == null || property.getSetterMethod().isAccessible()) continue;
            property.getSetterMethod().setAccessible(true);
        }
    }

    @Override
    public Object[] getValues(T obj) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object[] results = new Object[this._properties.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = this.getValue(obj, i);
        }
        return results;
    }

    @Override
    public void setValues(T obj, Object[] values) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (int i = 0; i < this._properties.length; ++i) {
            if (this._properties[i].getSetterMethod() == null) continue;
            this.setValue(obj, values[i], i);
        }
    }

    protected Object getValue(T obj, int i) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return this._properties[i].getGetterMethod().invoke(obj, new Object[0]);
    }

    protected void setValue(T obj, Object value, int i) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (!this._properties[i].isPrimitive()) {
            this._properties[i].getSetterMethod().invoke(obj, value);
        } else if (this._properties[i].hasNullValue()) {
            this._properties[i].getSetterMethod().invoke(obj, this.convertFromNullIfNeeded(value, i));
        } else if (value != null) {
            this._properties[i].getSetterMethod().invoke(obj, value);
        }
    }

    protected Object convertFromNullIfNeeded(Object value, int propertyIndex) {
        return this._properties[propertyIndex].convertFromNullIfNeeded(value);
    }
}

