/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.reflection.standard;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.SpaceTypeInfo;
import com.gigaspaces.internal.reflection.AbstractReflectionFactory;
import com.gigaspaces.internal.reflection.IConstructor;
import com.gigaspaces.internal.reflection.IField;
import com.gigaspaces.internal.reflection.IGetterMethod;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.IParamsConstructor;
import com.gigaspaces.internal.reflection.IProperties;
import com.gigaspaces.internal.reflection.ISetterMethod;
import com.gigaspaces.internal.reflection.ProxyInvocationHandler;
import com.gigaspaces.internal.reflection.standard.GetParametersNameUtil;
import com.gigaspaces.internal.reflection.standard.StandardConstructor;
import com.gigaspaces.internal.reflection.standard.StandardField;
import com.gigaspaces.internal.reflection.standard.StandardFieldProperties;
import com.gigaspaces.internal.reflection.standard.StandardGetterMethod;
import com.gigaspaces.internal.reflection.standard.StandardMethod;
import com.gigaspaces.internal.reflection.standard.StandardParamsConstructor;
import com.gigaspaces.internal.reflection.standard.StandardProperties;
import com.gigaspaces.internal.reflection.standard.StandardSetterMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

@InternalApi
public class StandardReflectionFactory
extends AbstractReflectionFactory {
    @Override
    public <T> IConstructor<T> getConstructor(Constructor<T> ctor) {
        return new StandardConstructor<T>(ctor);
    }

    @Override
    public <T> IParamsConstructor<T> getParamsConstructor(Constructor<T> ctor) {
        return new StandardParamsConstructor<T>(ctor);
    }

    @Override
    public <T> String[] getConstructorParametersNames(Constructor<T> ctor) {
        return GetParametersNameUtil.getParametersName(ctor);
    }

    @Override
    public <T> IMethod<T> getMethod(ClassLoader classLoader, Method method) {
        return new StandardMethod(method);
    }

    @Override
    public <T> IGetterMethod<T> getGetterMethod(ClassLoader classLoader, Method method) {
        return new StandardGetterMethod(method);
    }

    @Override
    public <T> ISetterMethod<T> getSetterMethod(ClassLoader classLoader, Method method) {
        return new StandardSetterMethod(method);
    }

    @Override
    public <T, F> IField<T, F> getField(Field field) {
        return new StandardField(field);
    }

    @Override
    public <T> IProperties<T> getFieldProperties(Class<T> declaringClass, Field[] fields) {
        return new StandardFieldProperties(fields);
    }

    @Override
    public <T> IProperties<T> getProperties(SpaceTypeInfo typeInfo) {
        return new StandardProperties(typeInfo.getSpaceProperties());
    }

    @Override
    public Object getProxy(ClassLoader loader, Class<?>[] interfaces, ProxyInvocationHandler handler, boolean allowCache) {
        if (handler instanceof InvocationHandler) {
            return Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)((Object)handler));
        }
        throw new IllegalArgumentException("Fail to create standard dynamic proxy, provided handler " + handler + " must implement " + InvocationHandler.class);
    }
}

