/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.internal.DefaultAsyncResult;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.RemoteOperationResult;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import com.gigaspaces.internal.utils.concurrent.ContextClassLoaderRunnable;
import com.gigaspaces.lrmi.LRMIRuntime;
import com.j_spaces.core.exception.internal.ProxyInternalSpaceException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class RemoteOperationFutureListener<T extends RemoteOperationResult>
implements AsyncFuture<Object> {
    protected final Logger _logger;
    private final CountDownLatch _completionLatch;
    private final boolean _getResultOnCompletion;
    private volatile Object _result;
    private volatile ExecutionException _exception;
    private volatile AsyncFutureListener<Object> _listener;
    private volatile boolean _triggeredListener;

    public RemoteOperationFutureListener(Logger logger, AsyncFutureListener<Object> listener) {
        this(logger, listener, true);
    }

    public RemoteOperationFutureListener(Logger logger, AsyncFutureListener<Object> listener, boolean getResultOnCompletion) {
        this._logger = logger;
        this._listener = listener;
        this._getResultOnCompletion = getResultOnCompletion;
        this._completionLatch = new CountDownLatch(1);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this._completionLatch.getCount() == 0L;
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        this._completionLatch.await();
        if (this._exception != null) {
            throw this._exception;
        }
        return this._result;
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        if (!this._completionLatch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this._exception != null) {
            throw this._exception;
        }
        return this._result;
    }

    @Override
    public void setListener(final AsyncFutureListener<Object> listener) {
        if (listener == null) {
            return;
        }
        this._listener = listener;
        if (this.isDone() && !this._triggeredListener) {
            LRMIRuntime.getRuntime().getThreadPool().execute(new ContextClassLoaderRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void execute() {
                    CountDownLatch countDownLatch = RemoteOperationFutureListener.this._completionLatch;
                    synchronized (countDownLatch) {
                        if (RemoteOperationFutureListener.this._triggeredListener) {
                            return;
                        }
                        RemoteOperationFutureListener.this._triggeredListener = true;
                    }
                    RemoteOperationFutureListener.this.invokeListener(listener);
                }
            });
        }
    }

    public void waitForCompletion() throws InterruptedException {
        this._completionLatch.await();
        if (this._exception != null) {
            Throwable executionException = this._exception.getCause();
            if (executionException instanceof RuntimeException) {
                throw (RuntimeException)executionException;
            }
            throw new ProxyInternalSpaceException(executionException);
        }
    }

    public boolean waitForCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        return this._completionLatch.await(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOperationCompletion(RemoteOperationRequest<T> request, RemoteOperationsExecutorProxy sourceProxy) {
        AsyncFutureListener<Object> listener = null;
        CountDownLatch countDownLatch = this._completionLatch;
        synchronized (countDownLatch) {
            boolean isCompleted;
            if (this.isDone()) {
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.log(Level.FINEST, "Operation already completed, ignoring " + request.getRemoteOperationResult() + (sourceProxy != null ? " from " + sourceProxy.toLogMessage(request) : ""));
                }
                return;
            }
            try {
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.log(Level.FINEST, "Received " + request.getRemoteOperationResult() + (sourceProxy != null ? " from " + sourceProxy.toLogMessage(request) : ""));
                }
                if ((isCompleted = this.onOperationResultArrival(request)) && this._getResultOnCompletion) {
                    this._result = this.getResult(request);
                }
            }
            catch (ExecutionException e) {
                isCompleted = true;
                this._exception = e;
            }
            catch (Exception e) {
                isCompleted = true;
                this._exception = new ExecutionException(e);
            }
            if (isCompleted) {
                this._completionLatch.countDown();
                if (!this._triggeredListener && (listener = this._listener) != null) {
                    this._triggeredListener = true;
                }
            }
        }
        if (listener != null) {
            if (Thread.currentThread().getName().contains("PostponedAsyncOperationsQueue-")) {
                final AsyncFutureListener<Object> listnr = listener;
                LRMIRuntime.getRuntime().getThreadPool().execute(new ContextClassLoaderRunnable(){

                    @Override
                    public void execute() {
                        RemoteOperationFutureListener.this.invokeListener(listnr);
                    }
                });
            } else {
                this.invokeListener(listener);
            }
        }
    }

    protected boolean onOperationResultArrival(RemoteOperationRequest<T> request) {
        return true;
    }

    protected Object getResult(RemoteOperationRequest<T> request) throws Exception {
        return request.getAsyncFinalResult();
    }

    private void invokeListener(AsyncFutureListener<Object> listener) {
        try {
            Exception exception = this._exception == null ? null : (Exception)this._exception.getCause();
            listener.onResult(new DefaultAsyncResult<Object>(this._result, exception));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

