/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing;

import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.RemoteOperationResult;
import com.gigaspaces.internal.remoting.routing.RemoteOperationRouter;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractRemoteOperationRouter
implements RemoteOperationRouter {
    protected final Logger _logger;

    public AbstractRemoteOperationRouter(String name) {
        this._logger = Logger.getLogger("com.gigaspaces.spaceproxy.router." + name);
    }

    protected void logBeforeExecute(RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request, boolean oneway) {
        if (oneway) {
            this.logBeforeExecuteOneway(proxy, request);
        } else if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "Starting execution of " + proxy.toLogMessage(request));
        }
    }

    protected void logBeforeExecuteAsync(RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request) {
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "Starting async execution of " + proxy.toLogMessage(request));
        }
    }

    private void logBeforeExecuteOneway(RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request) {
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "Starting oneway execution of " + proxy.toLogMessage(request));
        }
    }

    protected void logAfterExecute(RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request, RemoteOperationResult result, boolean oneway) {
        if (oneway) {
            this.logAfterExecuteOneway(proxy, request);
        } else if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "Execution result: " + result + ", request=" + proxy.toLogMessage(request));
        }
    }

    protected void logAfterExecuteAsync(RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request, RemoteOperationResult result) {
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "Async execution result: " + result + ", request=" + proxy.toLogMessage(request));
        }
    }

    private void logAfterExecuteOneway(RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request) {
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "Oneway execution completed, request=" + proxy.toLogMessage(request));
        }
    }

    protected void logExecutionFailure(RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request, Exception exception, boolean oneway) {
        if (oneway) {
            this.logOnewayExecutionFailure(proxy, request, exception);
        } else if (this._logger.isLoggable(Level.WARNING)) {
            this._logger.log(Level.WARNING, "Execution failed: " + exception + ", request=" + proxy.toLogMessage(request));
        }
    }

    protected void logAsyncExecutionFailure(RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request, Exception exception) {
        if (this._logger.isLoggable(Level.WARNING)) {
            this._logger.log(Level.WARNING, "Async execution failed: " + exception + ", request=" + proxy.toLogMessage(request));
        }
    }

    private void logOnewayExecutionFailure(RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request, Exception exception) {
        if (this._logger.isLoggable(Level.WARNING)) {
            this._logger.log(Level.WARNING, "Oneway execution failed: " + exception + ", request=" + proxy.toLogMessage(request));
        }
    }

    protected void logInterruptedExecution(RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request, Exception exception, boolean oneway) {
        if (oneway) {
            this.logInterruptedOnewayExecution(proxy, request, exception);
        } else if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Execution interrupted: " + exception + ", request=" + proxy.toLogMessage(request));
        }
    }

    protected void logInterruptedAsyncExecution(RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request, Exception exception) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Async execution interrupted: " + exception + ", request=" + proxy.toLogMessage(request));
        }
    }

    protected void logUnexpectedAsyncExecution(RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request, Exception exception) {
        if (this._logger.isLoggable(Level.WARNING)) {
            this._logger.log(Level.WARNING, "Async execution failed unexpectedly: " + exception + ", request=" + proxy.toLogMessage(request));
        }
    }

    private void logInterruptedOnewayExecution(RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request, Exception exception) {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Oneway execution interrupted: " + exception + ", request=" + proxy.toLogMessage(request));
        }
    }

    @Override
    public RemoteOperationsExecutorProxy getCachedMember() {
        throw new UnsupportedOperationException();
    }
}

