/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing.clustered;

import com.gigaspaces.admin.quiesce.QuiesceException;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.internal.remoting.RemoteOperationFutureListener;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.RemoteOperationResult;
import com.gigaspaces.internal.remoting.routing.AbstractRemoteOperationRouter;
import com.gigaspaces.internal.remoting.routing.clustered.PostponedAsyncOperationsQueue;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorsCluster;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.UnknownTypeException;
import com.j_spaces.core.UnknownTypesException;
import com.j_spaces.core.exception.internal.InterruptedSpaceException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;

@InternalApi
public class ClusterRemoteOperationRouter
extends AbstractRemoteOperationRouter {
    protected final RemoteOperationsExecutorsCluster _cluster;
    private final PostponedAsyncOperationsQueue _postponedAsyncOperationsQueue;

    public ClusterRemoteOperationRouter(RemoteOperationsExecutorsCluster cluster, PostponedAsyncOperationsQueue posponedAsyncOperationsQueue) {
        super(cluster.getName());
        this._cluster = cluster;
        this._postponedAsyncOperationsQueue = posponedAsyncOperationsQueue;
        if (this._logger.isLoggable(Level.CONFIG)) {
            this._logger.log(Level.CONFIG, "Initialized clustered router" + this._cluster.getPartitionDesc() + " - members=" + this._cluster.getMembersNames());
        }
    }

    @Override
    public <T extends RemoteOperationResult> void execute(RemoteOperationRequest<T> request) throws InterruptedException {
        this.executeImpl(request, false);
    }

    private <T extends RemoteOperationResult> void executeImpl(RemoteOperationRequest<T> request, boolean oneway) throws InterruptedException {
        ExecutionStatus status;
        long initialFailureTime = 0L;
        RemoteOperationsExecutorProxy proxy = this._cluster.getLoadBalancer().getCandidate(request);
        if (proxy == null) {
            initialFailureTime = SystemTime.timeMillis();
            if (this._logger.isLoggable(Level.WARNING)) {
                this._logger.log(Level.WARNING, "No active server" + this._cluster.getPartitionDesc() + " - attempting to locate an active server...");
            }
            if ((proxy = this._cluster.getLoadBalancer().findActiveMember(request, initialFailureTime, proxy)) == null) {
                return;
            }
        }
        do {
            RemoteOperationResult result = null;
            Exception executionException = null;
            try {
                if (!this.beforeOperationExecution(request, proxy)) {
                    return;
                }
                this.logBeforeExecute(proxy, request, oneway);
                if (oneway) {
                    proxy.executeOneway(request);
                    this.logAfterExecute(proxy, request, result, oneway);
                    return;
                }
                result = proxy.execute(request);
                this.logAfterExecute(proxy, request, result, oneway);
            }
            catch (RemoteException e) {
                this.logExecutionFailure(proxy, request, e, oneway);
                executionException = e;
            }
            catch (InterruptedSpaceException e) {
                this.logInterruptedExecution(proxy, request, e, oneway);
                result = (RemoteOperationResult)request.createRemoteOperationResult();
                result.setExecutionException(e);
            }
            if (result != null) {
                executionException = result.getExecutionException();
            }
            status = this.processResult(request, result, executionException);
            this.afterOperationExecution(request, proxy, status);
            if (status == ExecutionStatus.COMPLETED) {
                return;
            }
            this.logExecutionStatus("Operation", status, executionException, proxy, request);
            if (initialFailureTime == 0L) {
                initialFailureTime = SystemTime.timeMillis();
            }
            if (this._cluster.getRemainingTime(request, initialFailureTime) > 0L) continue;
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, this._cluster.generateTimeoutErrorMessage(initialFailureTime, request));
            }
            return;
        } while (status != ExecutionStatus.RETRY_OTHER || (proxy = this._cluster.getLoadBalancer().findActiveMember(request, initialFailureTime, proxy)) != null);
    }

    private void logExecutionStatus(String prefix, ExecutionStatus status, Exception exception, RemoteOperationsExecutorProxy proxy, RemoteOperationRequest<?> request) {
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, prefix + " ExecutionStatus=" + (Object)((Object)status) + (exception != null ? " exception=" + exception : "") + " for " + proxy.toLogMessage(request));
        }
    }

    protected void afterOperationExecution(RemoteOperationRequest<?> request, RemoteOperationsExecutorProxy proxy, ExecutionStatus status) {
    }

    protected <T extends RemoteOperationResult> ExecutionStatus processResult(RemoteOperationRequest<T> request, T result, Exception executionException) {
        if (executionException != null) {
            if (executionException instanceof RemoteException) {
                return ExecutionStatus.RETRY_OTHER;
            }
            if (executionException instanceof QuiesceException) {
                return ExecutionStatus.RETRY_OTHER;
            }
            if (executionException instanceof UnknownTypeException) {
                return request.processUnknownTypeException(null) ? ExecutionStatus.RETRY_SAME : ExecutionStatus.COMPLETED;
            }
            if (executionException instanceof UnknownTypesException) {
                List<Integer> positions = ((UnknownTypesException)executionException).getPositions();
                return request.processUnknownTypeException(positions) ? ExecutionStatus.RETRY_SAME : ExecutionStatus.COMPLETED;
            }
        }
        request.setRemoteOperationResult(result);
        return ExecutionStatus.COMPLETED;
    }

    protected boolean beforeOperationExecution(RemoteOperationRequest<?> request, RemoteOperationsExecutorProxy proxy) throws RemoteException {
        return true;
    }

    @Override
    public <T extends RemoteOperationResult> RemoteOperationFutureListener<T> createFutureListener(RemoteOperationRequest<T> request, AsyncFutureListener<Object> listener) {
        return new RemoteOperationFutureListener(this._logger, listener);
    }

    @Override
    public <T extends RemoteOperationResult> void executeAsync(RemoteOperationRequest<T> request, RemoteOperationFutureListener<T> futureListener) {
        AsyncOperationExecutor<T> asyncExecutor = new AsyncOperationExecutor<T>(request, futureListener);
        asyncExecutor.executeAsync();
    }

    @Override
    public void executeOneway(RemoteOperationRequest<?> request) throws InterruptedException {
        this.executeImpl(request, true);
    }

    @Override
    public RemoteOperationsExecutorProxy getCachedMember() {
        return this._cluster.getLoadBalancer().getCandidate(null);
    }

    @Override
    public RemoteOperationsExecutorProxy getAnyAvailableMember() {
        return this._cluster.getLoadBalancer().findAnyAvailableMember(false);
    }

    @Override
    public RemoteOperationsExecutorProxy getAnyActiveMember() {
        return this._cluster.getLoadBalancer().findAnyAvailableMember(true);
    }

    @Override
    public void getAllAvailableMembers(List<RemoteOperationsExecutorProxy> availableMembers) {
        this._cluster.getAllAvailableMembers(availableMembers);
    }

    @Override
    public void close() {
        this._cluster.close();
    }

    public class AsyncOperationExecutor<T extends RemoteOperationResult>
    implements AsyncFutureListener<T> {
        private final RemoteOperationRequest<T> _request;
        private final RemoteOperationFutureListener<T> _futureListener;
        private volatile RemoteOperationsExecutorProxy _proxy;
        private volatile ExecutionStatus _lastExecutionStatus;
        private volatile long _initialFailureTime;

        public AsyncOperationExecutor(RemoteOperationRequest<T> request, RemoteOperationFutureListener<T> listener) {
            this._request = request;
            this._futureListener = listener;
            this._proxy = ClusterRemoteOperationRouter.this._cluster.getLoadBalancer().getCandidate(request);
        }

        public void executeAsync() {
            if (this._proxy == null || this._lastExecutionStatus == ExecutionStatus.RETRY_OTHER) {
                if (this._initialFailureTime == 0L) {
                    this._initialFailureTime = SystemTime.timeMillis();
                }
                this._proxy = ClusterRemoteOperationRouter.this._cluster.getLoadBalancer().findActiveMemberUninterruptibly(this._request, this._initialFailureTime, this._proxy);
                if (this._proxy == null) {
                    this.onOperationCompletion();
                    return;
                }
            }
            while (true) {
                try {
                    if (!ClusterRemoteOperationRouter.this.beforeOperationExecution(this._request, this._proxy)) {
                        this.onOperationCompletion();
                        return;
                    }
                    ClusterRemoteOperationRouter.this.logBeforeExecuteAsync(this._proxy, this._request);
                    this._proxy.executeAsync(this._request, this);
                    return;
                }
                catch (RemoteException e) {
                    ClusterRemoteOperationRouter.this.logAsyncExecutionFailure(this._proxy, this._request, e);
                    if (this._initialFailureTime == 0L) {
                        this._initialFailureTime = SystemTime.timeMillis();
                    }
                    this._proxy = ClusterRemoteOperationRouter.this._cluster.getLoadBalancer().findActiveMemberUninterruptibly(this._request, this._initialFailureTime, this._proxy);
                    if (this._proxy != null) continue;
                    this.onOperationCompletion();
                    return;
                }
                catch (InterruptedSpaceException e) {
                    ClusterRemoteOperationRouter.this.logInterruptedAsyncExecution(this._proxy, this._request, e);
                    this._request.setRemoteOperationExecutionError((Exception)e.getCause());
                    this.onOperationCompletion();
                    return;
                }
                catch (Exception e) {
                    ClusterRemoteOperationRouter.this.logUnexpectedAsyncExecution(this._proxy, this._request, e);
                    this._request.setRemoteOperationExecutionError(e);
                    this.onOperationCompletion();
                    return;
                }
                break;
            }
        }

        @Override
        public void onResult(AsyncResult<T> asyncResult) {
            try {
                RemoteOperationResult result = (RemoteOperationResult)asyncResult.getResult();
                Exception exception = asyncResult.getException();
                if (exception != null) {
                    ClusterRemoteOperationRouter.this.logAsyncExecutionFailure(this._proxy, this._request, exception);
                } else {
                    ClusterRemoteOperationRouter.this.logAfterExecuteAsync(this._proxy, this._request, result);
                }
                if (exception == null) {
                    exception = result != null ? result.getExecutionException() : new IllegalStateException("Async operation completed without result or exception");
                }
                ExecutionStatus status = ClusterRemoteOperationRouter.this.processResult(this._request, result, exception);
                ClusterRemoteOperationRouter.this.afterOperationExecution(this._request, this._proxy, status);
                if (status == ExecutionStatus.COMPLETED) {
                    if (result == null) {
                        this._request.setRemoteOperationExecutionError(exception);
                    }
                    this.onOperationCompletion();
                    return;
                }
                ClusterRemoteOperationRouter.this.logExecutionStatus("Async operation", status, exception, this._proxy, this._request);
                this._lastExecutionStatus = status;
                ClusterRemoteOperationRouter.this._postponedAsyncOperationsQueue.enqueue(this);
            }
            catch (Exception e) {
                if (ClusterRemoteOperationRouter.this._logger.isLoggable(Level.SEVERE)) {
                    ClusterRemoteOperationRouter.this._logger.log(Level.SEVERE, "Unexpected exception during processing of async operation result. AsyncResult=" + asyncResult.toString() + ", request=" + this._request.toString(), e);
                }
                this._request.setRemoteOperationExecutionError(e);
                this.onOperationCompletion();
            }
        }

        private void onOperationCompletion() {
            this._futureListener.onOperationCompletion(this._request, this._proxy);
        }
    }

    protected static enum ExecutionStatus {
        COMPLETED,
        RETRY_OTHER,
        RETRY_SAME;

    }
}

