/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing.clustered;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorsCluster;
import com.gigaspaces.internal.remoting.routing.clustered.SpaceProxyLoadBalancingStrategy;
import java.util.logging.Level;

@InternalApi
public class LazyLoadBalancingStrategy
extends SpaceProxyLoadBalancingStrategy {
    private volatile RemoteOperationsExecutorProxy _activeProxy;
    private volatile boolean _activeProxyInitialized;

    public LazyLoadBalancingStrategy(RemoteOperationsExecutorsCluster cluster, RemoteOperationsExecutorProxy defaultMember) {
        super(cluster);
        this._activeProxy = defaultMember;
    }

    @Override
    public RemoteOperationsExecutorProxy getCandidate(RemoteOperationRequest<?> request) {
        return this._activeProxy;
    }

    @Override
    protected void updateActiveProxy(RemoteOperationsExecutorProxy newActiveProxy) {
        this._activeProxy = newActiveProxy;
        if (this._activeProxy != null) {
            if (this._activeProxyInitialized) {
                if (this._logger.isLoggable(Level.INFO)) {
                    this._logger.log(Level.INFO, "Active server" + this._cluster.getPartitionDesc() + " is updated to " + this._activeProxy.getName());
                }
            } else {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Active server" + this._cluster.getPartitionDesc() + " is initialized to " + this._activeProxy.getName());
                }
                this._activeProxyInitialized = true;
            }
        }
    }
}

