/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing.clustered;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.remoting.routing.clustered.ClusterRemoteOperationRouter;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.j_spaces.core.exception.ClosedResourceException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class PostponedAsyncOperationsQueue {
    public static final String THREADS_NAME_PREFIX = "PostponedAsyncOperationsQueue-";
    private static final int CAPACITY = 10000;
    private final Logger _logger;
    private final ThreadPoolExecutor _threadPoolExecutor;
    private final Object _lock = new Object();
    private volatile boolean _closed;

    public PostponedAsyncOperationsQueue(String name) {
        this._threadPoolExecutor = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(10000), (ThreadFactory)new GSThreadFactory(THREADS_NAME_PREFIX + name, true));
        this._logger = Logger.getLogger("com.gigaspaces.spaceproxy.router." + name);
    }

    public void enqueue(final ClusterRemoteOperationRouter.AsyncOperationExecutor<?> execotor) {
        try {
            this._threadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            execotor.executeAsync();
                        }
                        catch (Exception e) {
                            if (!PostponedAsyncOperationsQueue.this._logger.isLoggable(Level.WARNING)) break block2;
                            PostponedAsyncOperationsQueue.this._logger.log(Level.WARNING, "Unexpected exception caught in PostponedAsyncOperationsHandler", e);
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            if (!this._closed) {
                throw e;
            }
            throw new ClosedResourceException("Proxy is being closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            this._closed = true;
            this._threadPoolExecutor.shutdownNow();
        }
    }
}

