/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing.clustered;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.internal.quiesce.QuiesceTokenProvider;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.RemoteOperationResult;
import com.gigaspaces.internal.remoting.RemoteOperationsExecutor;
import com.gigaspaces.lrmi.ILRMIProxy;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.nio.async.FutureContext;
import java.rmi.RemoteException;

@InternalApi
public class RemoteOperationsExecutorProxy {
    private final String _name;
    private final RemoteOperationsExecutor _executor;
    private final QuiesceTokenProvider _quiesceTokenProvider;

    public RemoteOperationsExecutorProxy(String name, RemoteOperationsExecutor executor, QuiesceTokenProvider quiesceTokenProvider) {
        this._name = name;
        this._executor = executor;
        this._quiesceTokenProvider = quiesceTokenProvider;
    }

    public String getName() {
        return this._name;
    }

    public RemoteOperationsExecutor getExecutor() {
        return this._executor;
    }

    public <T extends RemoteOperationResult> T execute(RemoteOperationRequest<T> request) throws RemoteException {
        if (request.isBlockingOperation()) {
            LRMIInvocationContext.enableCallbackModeForNextInvocation();
        }
        if (request.isDedicatedPoolRequired()) {
            LRMIInvocationContext.enableCustomPriorityForNextInvocation();
        }
        return this._executor.executeOperation(request);
    }

    public <T extends RemoteOperationResult> void executeAsync(RemoteOperationRequest<T> request, AsyncFutureListener<T> listener) throws RemoteException {
        try {
            if (request.isBlockingOperation()) {
                LRMIInvocationContext.enableCallbackModeForNextInvocation();
            }
            if (request.isDedicatedPoolRequired()) {
                LRMIInvocationContext.enableCustomPriorityForNextInvocation();
            }
            FutureContext.setFutureListener(listener);
            this._executor.executeOperationAsync(request);
        }
        finally {
            FutureContext.clear();
        }
    }

    public void executeOneway(RemoteOperationRequest<?> request) throws RemoteException {
        this._executor.executeOperationOneway(request);
    }

    public boolean isActive() throws RemoteException {
        return this._executor.isActive();
    }

    public boolean isActiveQuiesceTokenAware() throws RemoteException {
        if (this._quiesceTokenProvider.getToken() != null) {
            return this._executor.isActive();
        }
        return this._executor.isActiveAndNotSuspended();
    }

    public String toLogMessage(RemoteOperationRequest<?> request) {
        return this._name + "=>" + request.toString();
    }

    public void close() {
        if (this._executor instanceof ILRMIProxy) {
            ((ILRMIProxy)((Object)this._executor)).closeProxy();
        }
    }

    public static boolean isAvailable(RemoteOperationsExecutorProxy proxy, boolean activeOnly) {
        if (proxy == null) {
            return false;
        }
        try {
            boolean isActive = proxy.isActiveQuiesceTokenAware();
            return isActive || !activeOnly;
        }
        catch (RemoteException e) {
            return false;
        }
    }
}

