/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing.clustered;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.cluster.SpaceProxyLoadBalancerType;
import com.gigaspaces.internal.remoting.RemoteOperationRequest;
import com.gigaspaces.internal.remoting.routing.RemoteOperationRouterException;
import com.gigaspaces.internal.remoting.routing.clustered.LazyLoadBalancingStrategy;
import com.gigaspaces.internal.remoting.routing.clustered.LookupType;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxyLocator;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorsClusterConfig;
import com.gigaspaces.internal.remoting.routing.clustered.RoundRobinLoadBalancingStrategy;
import com.gigaspaces.internal.remoting.routing.clustered.SpaceProxyLoadBalancingStrategy;
import com.gigaspaces.internal.utils.concurrent.CompetitiveTask;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.TimedCompetitionExecutor;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.exception.ClosedResourceException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class RemoteOperationsExecutorsCluster {
    private final Logger _logger;
    private final String _name;
    private final SpaceClusterInfo _clusterInfo;
    private final int _partitionId;
    private final String _partitionName;
    private final Map<String, RemoteOperationsExecutorProxy> _members;
    private final RemoteOperationsExecutorsClusterConfig _config;
    private final Object _lock;
    private final IAsyncHandlerProvider _asyncHandlerProvider;
    private final RemoteOperationsExecutorProxyLocator _proxyLocator;
    private final SpaceProxyLoadBalancingStrategy _loadBalancer;
    private boolean _closed;

    public RemoteOperationsExecutorsCluster(String name, SpaceClusterInfo clusterInfo, int partitionId, Collection<String> members, RemoteOperationsExecutorsClusterConfig config, IAsyncHandlerProvider asyncHandlerProvider, RemoteOperationsExecutorProxyLocator proxyLocator, RemoteOperationsExecutorProxy defaultMember) {
        this._logger = Logger.getLogger("com.gigaspaces.spaceproxy.router.lookup." + name);
        this._lock = new Object();
        this._name = name;
        this._clusterInfo = clusterInfo;
        this._partitionId = partitionId;
        this._partitionName = this._partitionId == -1 ? name : name + '#' + (partitionId + 1);
        this._members = new HashMap<String, RemoteOperationsExecutorProxy>();
        for (String member : members) {
            this._members.put(member, null);
        }
        this._config = config;
        this._asyncHandlerProvider = asyncHandlerProvider;
        this._proxyLocator = proxyLocator;
        this._loadBalancer = this.createLoadBalancer(config, members, defaultMember);
        if (config.getLoadBalancerType() == SpaceProxyLoadBalancerType.ROUND_ROBIN) {
            this.refreshDisconnectedMembers();
        }
    }

    public String getName() {
        return this._name;
    }

    public Logger getLogger() {
        return this._logger;
    }

    public SpaceClusterInfo getClusterInfo() {
        return this._clusterInfo;
    }

    public int getPartitionId() {
        return this._partitionId;
    }

    public String getPartitionDesc() {
        return this._partitionId == -1 ? "" : " for partition #" + (this._partitionId + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getMembersNames() {
        Object object = this._lock;
        synchronized (object) {
            return this._members.keySet();
        }
    }

    public SpaceProxyLoadBalancingStrategy getLoadBalancer() {
        return this._loadBalancer;
    }

    public RemoteOperationsExecutorsClusterConfig getConfig() {
        return this._config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteOperationsExecutorProxy getAvailableMember(boolean activeOnly, long timeout) throws InterruptedException, RemoteOperationRouterException {
        int i;
        CompetitiveTask[] tasks;
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Timeout must be bigger than 0, got: " + timeout);
        }
        boolean timeBased = timeout > 0L;
        Object object = this._lock;
        synchronized (object) {
            this.validateNotClosed();
            tasks = new MemberLocatorTask[this._members.size()];
            i = 0;
            for (Map.Entry<String, RemoteOperationsExecutorProxy> entry : this._members.entrySet()) {
                tasks[i++] = new MemberLocatorTask(entry.getKey(), entry.getValue(), activeOnly, timeBased);
            }
        }
        if (this._logger.isLoggable(Level.FINE)) {
            String message = "Starting " + (activeOnly ? "active" : "available") + " server lookup" + this.getPartitionDesc() + " [timeout=" + timeout + "ms, members=(" + tasks[0]._memberName;
            for (i = 1; i < tasks.length; ++i) {
                message = message + ", " + ((MemberLocatorTask)tasks[i])._memberName;
            }
            message = message + ")]...";
            this._logger.log(Level.FINE, message);
        }
        String competitionName = (activeOnly ? "Active" : "Available") + "MemberLocator_" + this._partitionName;
        long competitionInterval = this._config.getActiveServerLookupSamplingInterval();
        TimedCompetitionExecutor competition = new TimedCompetitionExecutor(tasks, timeout, competitionName, this._asyncHandlerProvider, competitionInterval);
        try {
            MemberLocatorTask winner = (MemberLocatorTask)competition.await(timeout, TimeUnit.MILLISECONDS);
            return winner == null ? null : winner.getProxy();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ClosedResourceException) {
                throw (ClosedResourceException)e.getCause();
            }
            String message = "Unexpected exception while locating an " + (activeOnly ? "active" : "available") + " server" + this.getPartitionDesc();
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, message, e.getCause());
            }
            throw new RemoteOperationRouterException(message, e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllAvailableMembers(List<RemoteOperationsExecutorProxy> availableMembers) {
        ArrayList<String> membersToFind = new ArrayList<String>();
        Iterator iterator = this._lock;
        synchronized (iterator) {
            this.validateNotClosed();
            for (Map.Entry<String, RemoteOperationsExecutorProxy> entry : this._members.entrySet()) {
                if (entry.getValue() != null) {
                    availableMembers.add(entry.getValue());
                    continue;
                }
                membersToFind.add(entry.getKey());
            }
        }
        for (String member : membersToFind) {
            RemoteOperationsExecutorProxy proxy = this.find(member, LookupType.RepeatsBased);
            if (proxy == null) continue;
            availableMembers.add(proxy);
        }
    }

    private void validateNotClosed() {
        if (this._closed) {
            throw new ClosedResourceException("Proxy is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshConnectedMembers() {
        ArrayList<RemoteOperationsExecutorProxy> connectedMembers = new ArrayList<RemoteOperationsExecutorProxy>();
        Iterator iterator = this._lock;
        synchronized (iterator) {
            this.validateNotClosed();
            for (Map.Entry<String, RemoteOperationsExecutorProxy> entry : this._members.entrySet()) {
                if (entry.getValue() == null) continue;
                connectedMembers.add(entry.getValue());
            }
        }
        for (RemoteOperationsExecutorProxy proxy : connectedMembers) {
            try {
                proxy.isActive();
            }
            catch (RemoteException e) {
                this.disconnect(proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDisconnectedMembers() {
        ArrayList<String> disconnectedMembers = new ArrayList<String>();
        Iterator iterator = this._lock;
        synchronized (iterator) {
            this.validateNotClosed();
            for (Map.Entry<String, RemoteOperationsExecutorProxy> entry : this._members.entrySet()) {
                if (entry.getValue() != null) continue;
                disconnectedMembers.add(entry.getKey());
            }
        }
        for (String member : disconnectedMembers) {
            this.find(member, LookupType.RepeatsBased);
        }
    }

    public RemoteOperationsExecutorProxy find(String member, LookupType lookupType) {
        RemoteOperationsExecutorProxy proxy = this._proxyLocator.locateMember(member, lookupType);
        if (proxy != null) {
            this.add(proxy);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RemoteOperationsExecutorProxy proxy) {
        Object object = this._lock;
        synchronized (object) {
            this.validateNotClosed();
            this._members.put(proxy.getName(), proxy);
        }
        this._loadBalancer.onMemberConnected(proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(RemoteOperationsExecutorProxy proxy) {
        if (proxy == null) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            this.validateNotClosed();
            RemoteOperationsExecutorProxy oldProxy = this._members.get(proxy.getName());
            if (oldProxy != proxy) {
                return;
            }
            this._members.put(proxy.getName(), null);
        }
        this._loadBalancer.onMemberDisconnected(proxy.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this._lock;
        synchronized (object) {
            if (this._closed) {
                return;
            }
            for (RemoteOperationsExecutorProxy proxy : this._members.values()) {
                if (proxy == null) continue;
                proxy.close();
            }
            this._members.clear();
        }
    }

    public long getRemainingTime(RemoteOperationRequest<?> request, long initialFailureTime) {
        long remainingTime = this._config.getActiveServerLookupTimeout() - (SystemTime.timeMillis() - initialFailureTime);
        if (remainingTime <= 0L) {
            request.setRemoteOperationExecutionError(new RemoteException(this.generateTimeoutErrorMessage(initialFailureTime, request)));
        }
        return remainingTime;
    }

    public String generateTimeoutErrorMessage(long initialFailureTime, RemoteOperationRequest<?> request) {
        return "Failed to find an active server" + this.getPartitionDesc() + " to execute " + request.toString() + this.getElapsedTime(initialFailureTime);
    }

    public String getElapsedTime(long initialFailureTime) {
        long elapsedTime = SystemTime.timeMillis() - initialFailureTime;
        return "(elapsed time: " + elapsedTime + "ms)";
    }

    private SpaceProxyLoadBalancingStrategy createLoadBalancer(RemoteOperationsExecutorsClusterConfig config, Collection<String> members, RemoteOperationsExecutorProxy defaultMember) {
        SpaceProxyLoadBalancerType loadBalancerType = config.getLoadBalancerType();
        switch (loadBalancerType) {
            case STICKY: {
                return new LazyLoadBalancingStrategy(this, defaultMember);
            }
            case ROUND_ROBIN: {
                return new RoundRobinLoadBalancingStrategy(this, members, config.getNumOfOperationsTypes());
            }
        }
        throw new IllegalStateException("Unsupported load balancer type " + (Object)((Object)loadBalancerType));
    }

    public class MemberLocatorTask
    implements CompetitiveTask {
        private final String _memberName;
        private final boolean _activeOnly;
        private volatile RemoteOperationsExecutorProxy _proxy;
        private final boolean _timeBased;

        public MemberLocatorTask(String name, RemoteOperationsExecutorProxy proxy, boolean activeOnly, boolean timeBased) {
            this._memberName = name;
            this._proxy = proxy;
            this._activeOnly = activeOnly;
            this._timeBased = timeBased;
        }

        public RemoteOperationsExecutorProxy getProxy() {
            return this._proxy;
        }

        @Override
        public boolean execute(boolean isLastIteration) {
            if (this._proxy == null) {
                LookupType lookupType = !this._timeBased ? LookupType.RepeatsBased : (isLastIteration ? LookupType.TimeBasedLastIteration : LookupType.TimeBased);
                this._proxy = RemoteOperationsExecutorsCluster.this.find(this._memberName, lookupType);
                if (this._proxy == null) {
                    return false;
                }
            }
            if (RemoteOperationsExecutorsCluster.this._logger.isLoggable(Level.FINEST)) {
                RemoteOperationsExecutorsCluster.this._logger.log(Level.FINEST, "Checking if " + this._memberName + (this._activeOnly ? " is active..." : " is available..."));
            }
            try {
                boolean isActive = this._proxy.isActiveQuiesceTokenAware();
                if (!this._activeOnly) {
                    if (RemoteOperationsExecutorsCluster.this._logger.isLoggable(Level.FINE)) {
                        RemoteOperationsExecutorsCluster.this._logger.log(Level.FINE, "Member " + this._memberName + " is available.");
                    }
                    return true;
                }
                if (isActive) {
                    if (RemoteOperationsExecutorsCluster.this._logger.isLoggable(Level.FINE)) {
                        RemoteOperationsExecutorsCluster.this._logger.log(Level.FINE, "Member " + this._memberName + " is active.");
                    }
                } else if (RemoteOperationsExecutorsCluster.this._logger.isLoggable(Level.FINER)) {
                    RemoteOperationsExecutorsCluster.this._logger.log(Level.FINER, "Member " + this._memberName + " is not active.");
                }
                return isActive;
            }
            catch (RemoteException e) {
                if (RemoteOperationsExecutorsCluster.this._logger.isLoggable(Level.FINER)) {
                    RemoteOperationsExecutorsCluster.this._logger.log(Level.FINER, "Member " + this._memberName + " failed to respond: " + e.getClass().getName() + ": " + e.getMessage());
                }
                RemoteOperationsExecutorsCluster.this.disconnect(this._proxy);
                this._proxy = null;
                return false;
            }
        }
    }
}

