/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.remoting.routing.clustered;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.quiesce.QuiesceTokenProvider;
import com.gigaspaces.internal.remoting.routing.clustered.LookupType;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxy;
import com.gigaspaces.internal.remoting.routing.clustered.RemoteOperationsExecutorProxyLocator;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.SpaceURL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class RemoteSpaceProxyLocator
implements RemoteOperationsExecutorProxyLocator {
    private static final long LOOKUP_TIMEOUT = 1L;
    private final Logger _logger;
    private final SpaceURL _spaceURL;
    private final Map<String, SpaceURL> _membersUrls;
    private final QuiesceTokenProvider _quiesceTokenProvider;

    public RemoteSpaceProxyLocator(String name, SpaceURL spaceUrl, QuiesceTokenProvider quiesceTokenProvider) {
        this._logger = Logger.getLogger("com.gigaspaces.spaceproxy.router.lookup." + name);
        this._spaceURL = spaceUrl;
        this._membersUrls = new ConcurrentHashMap<String, SpaceURL>();
        this._quiesceTokenProvider = quiesceTokenProvider;
    }

    public SpaceURL getMemberUrl(String memberName) {
        SpaceURL memberURL = this._membersUrls.get(memberName);
        if (memberURL != null) {
            return memberURL;
        }
        memberURL = this._spaceURL.clone();
        String[] names = memberName.split(":");
        memberURL.setContainerName(names[0]);
        memberURL.setSpaceName(names[1]);
        memberURL.refreshUrlString();
        this._membersUrls.put(memberName, memberURL);
        return memberURL;
    }

    public RemoteOperationsExecutorProxy locateMember(String memberName, String spaceUuid, LookupType lookupType) {
        SpaceURL memberURL = this.getMemberUrl(memberName);
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINEST, "Looking for server " + memberName + " at [" + memberURL + "]...");
        }
        try {
            IRemoteSpace proxy = SpaceFinder.findJiniSpace(memberURL, spaceUuid, memberURL.getCustomProperties(), 1L, lookupType);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Server " + memberName + " was found at [" + memberURL + "].");
            }
            return new RemoteOperationsExecutorProxy(memberName, proxy, this._quiesceTokenProvider);
        }
        catch (FinderException e) {
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.log(Level.FINEST, "Could not find server " + memberName + " at " + memberURL + ".", e);
            } else if (this._logger.isLoggable(Level.FINER)) {
                this._logger.log(Level.FINER, "Could not find server " + memberName + " at " + memberURL + ".");
            }
            return null;
        }
    }

    @Override
    public RemoteOperationsExecutorProxy locateMember(String memberName, LookupType lookupType) {
        return this.locateMember(memberName, null, lookupType);
    }
}

